/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;

public class GaussianSampler
implements ContinuousSampler {
    private final double mean;
    private final double standardDeviation;
    private final NormalizedGaussianSampler normalized;

    public GaussianSampler(NormalizedGaussianSampler normalized, double mean, double standardDeviation) {
        this.normalized = normalized;
        this.mean = mean;
        this.standardDeviation = standardDeviation;
    }

    @Override
    public double sample() {
        return this.standardDeviation * this.normalized.sample() + this.mean;
    }

    public String toString() {
        return "Gaussian deviate [" + this.normalized.toString() + "]";
    }
}

