/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import java.util.function.DoubleUnaryOperator;
import org.apache.commons.numbers.core.Precision;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousInverseCumulativeProbabilityFunction;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.InverseTransformContinuousSampler;
import org.apache.commons.statistics.distribution.ContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

abstract class AbstractContinuousDistribution
implements ContinuousDistribution {
    AbstractContinuousDistribution() {
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        boolean chebyshevApplies;
        if (p < 0.0 || p > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", p, 0, 1);
        }
        double lowerBound = this.getSupportLowerBound();
        if (p == 0.0) {
            return lowerBound;
        }
        double upperBound = this.getSupportUpperBound();
        if (p == 1.0) {
            return upperBound;
        }
        double mu = this.getMean();
        double sig = Math.sqrt(this.getVariance());
        boolean bl = chebyshevApplies = !Double.isInfinite(mu) && !Double.isNaN(mu) && !Double.isInfinite(sig) && !Double.isNaN(sig);
        if (lowerBound == Double.NEGATIVE_INFINITY) {
            if (chebyshevApplies) {
                lowerBound = mu - sig * Math.sqrt((1.0 - p) / p);
            } else {
                lowerBound = -1.0;
                while (this.cumulativeProbability(lowerBound) >= p) {
                    lowerBound *= 2.0;
                }
            }
        }
        if (upperBound == Double.POSITIVE_INFINITY) {
            if (chebyshevApplies) {
                upperBound = mu + sig * Math.sqrt(p / (1.0 - p));
            } else {
                upperBound = 1.0;
                while (this.cumulativeProbability(upperBound) < p) {
                    upperBound *= 2.0;
                }
            }
        }
        double solverRelativeAccuracy = 1.0E-14;
        double solverAbsoluteAccuracy = 1.0E-9;
        double solverFunctionValueAccuracy = 1.0E-15;
        double x = new BrentSolver(1.0E-14, 1.0E-9, 1.0E-15).solve(arg -> this.cumulativeProbability(arg) - p, lowerBound, 0.5 * (lowerBound + upperBound), upperBound);
        if (!this.isSupportConnected()) {
            double dx = 1.0E-9;
            if (x - 1.0E-9 >= this.getSupportLowerBound()) {
                double px = this.cumulativeProbability(x);
                if (this.cumulativeProbability(x - 1.0E-9) == px) {
                    upperBound = x;
                    while (upperBound - lowerBound > 1.0E-9) {
                        double midPoint = 0.5 * (lowerBound + upperBound);
                        if (this.cumulativeProbability(midPoint) < px) {
                            lowerBound = midPoint;
                            continue;
                        }
                        upperBound = midPoint;
                    }
                    return upperBound;
                }
            }
        }
        return x;
    }

    public static double[] sample(int n, ContinuousDistribution.Sampler sampler) {
        double[] samples = new double[n];
        for (int i = 0; i < n; ++i) {
            samples[i] = sampler.sample();
        }
        return samples;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(final UniformRandomProvider rng) {
        return new ContinuousDistribution.Sampler(){
            private final ContinuousSampler sampler;
            {
                this.sampler = new InverseTransformContinuousSampler(rng, AbstractContinuousDistribution.this.createICPF());
            }

            @Override
            public double sample() {
                return this.sampler.sample();
            }
        };
    }

    private ContinuousInverseCumulativeProbabilityFunction createICPF() {
        return new ContinuousInverseCumulativeProbabilityFunction(){

            @Override
            public double inverseCumulativeProbability(double p) {
                return AbstractContinuousDistribution.this.inverseCumulativeProbability(p);
            }
        };
    }

    private static class BrentSolver {
        private final double relativeAccuracy;
        private final double absoluteAccuracy;
        private final double functionValueAccuracy;

        BrentSolver(double relativeAccuracy, double absoluteAccuracy, double functionValueAccuracy) {
            this.relativeAccuracy = relativeAccuracy;
            this.absoluteAccuracy = absoluteAccuracy;
            this.functionValueAccuracy = functionValueAccuracy;
        }

        double solve(DoubleUnaryOperator func, double min, double initial, double max) {
            if (min > max) {
                throw new DistributionException("{0} > {1}", min, max);
            }
            if (initial < min || initial > max) {
                throw new DistributionException("Number {0} is out of range [{1}, {2}]", initial, min, max);
            }
            double yInitial = func.applyAsDouble(initial);
            if (Math.abs(yInitial) <= this.functionValueAccuracy) {
                return initial;
            }
            double yMin = func.applyAsDouble(min);
            if (Math.abs(yMin) <= this.functionValueAccuracy) {
                return min;
            }
            if (yInitial * yMin < 0.0) {
                return this.brent(func, min, initial, yMin, yInitial);
            }
            double yMax = func.applyAsDouble(max);
            if (Math.abs(yMax) <= this.functionValueAccuracy) {
                return max;
            }
            if (yInitial * yMax < 0.0) {
                return this.brent(func, initial, max, yInitial, yMax);
            }
            throw new DistributionException("No bracketing: f({0})={1}, f({2})={3}", min, yMin, max, yMax);
        }

        private double brent(DoubleUnaryOperator func, double lo, double hi, double fLo, double fHi) {
            double d;
            double a = lo;
            double fa = fLo;
            double b = hi;
            double fb = fHi;
            double c = a;
            double fc = fa;
            double e = d = b - a;
            double t = this.absoluteAccuracy;
            double eps = this.relativeAccuracy;
            while (true) {
                if (Math.abs(fc) < Math.abs(fb)) {
                    a = b;
                    b = c;
                    c = a;
                    fa = fb;
                    fb = fc;
                    fc = fa;
                }
                double tol = 2.0 * eps * Math.abs(b) + t;
                double m = 0.5 * (c - b);
                if (Math.abs(m) <= tol || Precision.equals(fb, 0.0)) {
                    return b;
                }
                if (Math.abs(e) < tol || Math.abs(fa) <= Math.abs(fb)) {
                    e = d = m;
                } else {
                    double q;
                    double p;
                    double s = fb / fa;
                    if (a == c) {
                        p = 2.0 * m * s;
                        q = 1.0 - s;
                    } else {
                        q = fa / fc;
                        double r = fb / fc;
                        p = s * (2.0 * m * q * (q - r) - (b - a) * (r - 1.0));
                        q = (q - 1.0) * (r - 1.0) * (s - 1.0);
                    }
                    if (p > 0.0) {
                        q = -q;
                    } else {
                        p = -p;
                    }
                    s = e;
                    e = d;
                    if (p >= 1.5 * m * q - Math.abs(tol * q) || p >= Math.abs(0.5 * s * q)) {
                        e = d = m;
                    } else {
                        d = p / q;
                    }
                }
                a = b;
                fa = fb;
                b = Math.abs(d) > tol ? (b += d) : (m > 0.0 ? (b += tol) : (b -= tol));
                fb = func.applyAsDouble(b);
                if (!(fb > 0.0 && fc > 0.0) && (!(fb <= 0.0) || !(fc <= 0.0))) continue;
                c = a;
                fc = fa;
                e = d = b - a;
            }
        }
    }
}

