/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.gamma;

import org.apache.commons.numbers.fraction.ContinuedFraction;
import org.apache.commons.numbers.gamma.GammaException;
import org.apache.commons.numbers.gamma.LogGamma;

public class RegularizedGamma {
    private static final double DEFAULT_EPSILON = 1.0E-15;

    public static class Q {
        public static double value(double a, double x) {
            return Q.value(a, x, 1.0E-15, Integer.MAX_VALUE);
        }

        public static double value(final double a, double x, double epsilon, int maxIterations) {
            if (Double.isNaN(a) || Double.isNaN(x) || a <= 0.0 || x < 0.0) {
                return Double.NaN;
            }
            if (x == 0.0) {
                return 1.0;
            }
            if (x < a + 1.0) {
                P p = new P();
                return 1.0 - P.value(a, x, epsilon, maxIterations);
            }
            ContinuedFraction cf = new ContinuedFraction(){

                @Override
                protected double getA(int n, double x) {
                    return (double)(2 * n + 1) - a + x;
                }

                @Override
                protected double getB(int n, double x) {
                    return (double)n * (a - (double)n);
                }
            };
            return Math.exp(-x + a * Math.log(x) - LogGamma.value(a)) / cf.evaluate(x, epsilon, maxIterations);
        }
    }

    public static class P {
        public static double value(double a, double x) {
            return P.value(a, x, 1.0E-15, Integer.MAX_VALUE);
        }

        public static double value(double a, double x, double epsilon, int maxIterations) {
            double sum;
            double an;
            if (Double.isNaN(a) || Double.isNaN(x) || a <= 0.0 || x < 0.0) {
                return Double.NaN;
            }
            if (x == 0.0) {
                return 0.0;
            }
            if (x >= a + 1.0) {
                Q q = new Q();
                return 1.0 - Q.value(a, x, epsilon, maxIterations);
            }
            double n = 0.0;
            for (sum = an = 1.0 / a; Math.abs(an / sum) > epsilon && n < (double)maxIterations && sum < Double.POSITIVE_INFINITY; sum += (an *= x / (a + (n += 1.0)))) {
            }
            if (n >= (double)maxIterations) {
                throw new GammaException("Failed to converge within {0} iterations", maxIterations);
            }
            if (Double.isInfinite(sum)) {
                return 1.0;
            }
            return Math.exp(-x + a * Math.log(x) - LogGamma.value(a)) * sum;
        }
    }
}

