/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.simple.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.core.source32.ISAACRandom;
import org.apache.commons.rng.core.source32.JDKRandom;
import org.apache.commons.rng.core.source32.KISSRandom;
import org.apache.commons.rng.core.source32.MersenneTwister;
import org.apache.commons.rng.core.source32.MultiplyWithCarry256;
import org.apache.commons.rng.core.source32.Well1024a;
import org.apache.commons.rng.core.source32.Well19937a;
import org.apache.commons.rng.core.source32.Well19937c;
import org.apache.commons.rng.core.source32.Well44497a;
import org.apache.commons.rng.core.source32.Well44497b;
import org.apache.commons.rng.core.source32.Well512a;
import org.apache.commons.rng.core.source64.MersenneTwister64;
import org.apache.commons.rng.core.source64.SplitMix64;
import org.apache.commons.rng.core.source64.TwoCmres;
import org.apache.commons.rng.core.source64.XorShift1024Star;
import org.apache.commons.rng.simple.internal.ByteArray2IntArray;
import org.apache.commons.rng.simple.internal.ByteArray2LongArray;
import org.apache.commons.rng.simple.internal.Int2Long;
import org.apache.commons.rng.simple.internal.IntArray2Int;
import org.apache.commons.rng.simple.internal.IntArray2LongArray;
import org.apache.commons.rng.simple.internal.Long2Int;
import org.apache.commons.rng.simple.internal.Long2IntArray;
import org.apache.commons.rng.simple.internal.Long2LongArray;
import org.apache.commons.rng.simple.internal.LongArray2IntArray;
import org.apache.commons.rng.simple.internal.LongArray2Long;
import org.apache.commons.rng.simple.internal.NoOpConverter;
import org.apache.commons.rng.simple.internal.SeedConverter;
import org.apache.commons.rng.simple.internal.SeedConverterComposer;
import org.apache.commons.rng.simple.internal.SeedFactory;

public final class ProviderBuilder {
    private static final String INTERNAL_ERROR_MSG = "Internal error: Please file a bug report";
    private static final int RANDOM_SEED_ARRAY_SIZE = 128;
    private static final Long2Int LONG_TO_INT = new Long2Int();
    private static final Int2Long INT_TO_LONG = new Int2Long();
    private static final Long2IntArray LONG_TO_INT_ARRAY = new Long2IntArray(128);
    private static final Long2LongArray LONG_TO_LONG_ARRAY = new Long2LongArray(128);
    private static final LongArray2Long LONG_ARRAY_TO_LONG = new LongArray2Long();
    private static final IntArray2Int INT_ARRAY_TO_INT = new IntArray2Int();
    private static final LongArray2IntArray LONG_ARRAY_TO_INT_ARRAY = new LongArray2IntArray();
    private static final IntArray2LongArray INT_ARRAY_TO_LONG_ARRAY = new IntArray2LongArray();
    private static final ByteArray2IntArray BYTE_ARRAY_TO_INT_ARRAY = new ByteArray2IntArray();
    private static final ByteArray2LongArray BYTE_ARRAY_TO_LONG_ARRAY = new ByteArray2LongArray();
    private static final Map<Class<?>, SeedConverter<Integer, ?>> CONV_INT = new ConcurrentHashMap();
    private static final Map<Class<?>, SeedConverter<int[], ?>> CONV_INT_ARRAY = new ConcurrentHashMap();
    private static final Map<Class<?>, SeedConverter<Long, ?>> CONV_LONG = new ConcurrentHashMap();
    private static final Map<Class<?>, SeedConverter<long[], ?>> CONV_LONG_ARRAY = new ConcurrentHashMap();
    private static final Map<Class<?>, SeedConverter<byte[], ?>> CONV_BYTE_ARRAY = new ConcurrentHashMap();

    private ProviderBuilder() {
    }

    public static RestorableUniformRandomProvider create(RandomSourceInternal source, Object seed, Object[] args) {
        Object nativeSeed = ProviderBuilder.createSeed(source, seed);
        ArrayList<Object> all = new ArrayList<Object>();
        all.add(nativeSeed);
        if (args != null) {
            all.addAll(Arrays.asList(args));
        }
        return ProviderBuilder.create(ProviderBuilder.createConstructor(source), all.toArray());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object createSeed(RandomSourceInternal source, Object seed) {
        Object nativeSeed = null;
        if (seed == null) {
            if (source.getSeed().equals(Integer.class)) {
                return SeedFactory.createInt();
            }
            if (source.getSeed().equals(Long.class)) {
                return SeedFactory.createLong();
            }
            if (source.getSeed().equals(int[].class)) {
                return SeedFactory.createIntArray(128);
            }
            if (!source.getSeed().equals(long[].class)) throw new IllegalStateException(INTERNAL_ERROR_MSG);
            return SeedFactory.createLongArray(128);
        }
        if (seed instanceof Integer) {
            nativeSeed = CONV_INT.get(source.getSeed()).convert((Integer)seed);
        } else if (seed instanceof Long) {
            nativeSeed = CONV_LONG.get(source.getSeed()).convert((Long)seed);
        } else if (seed instanceof int[]) {
            nativeSeed = CONV_INT_ARRAY.get(source.getSeed()).convert((int[])seed);
        } else if (seed instanceof long[]) {
            nativeSeed = CONV_LONG_ARRAY.get(source.getSeed()).convert((long[])seed);
        } else if (seed instanceof byte[]) {
            nativeSeed = CONV_BYTE_ARRAY.get(source.getSeed()).convert((byte[])seed);
        }
        if (nativeSeed == null) {
            throw new UnsupportedOperationException("Unrecognized seed type");
        }
        if (source.isNativeSeed(nativeSeed)) return nativeSeed;
        throw new IllegalStateException(INTERNAL_ERROR_MSG);
    }

    private static Constructor<?> createConstructor(RandomSourceInternal source) {
        try {
            return source.getRng().getConstructor(source.getArgs());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(INTERNAL_ERROR_MSG, e);
        }
    }

    private static RestorableUniformRandomProvider create(Constructor<?> rng, Object[] args) {
        try {
            return (RestorableUniformRandomProvider)rng.newInstance(args);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(INTERNAL_ERROR_MSG, e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(INTERNAL_ERROR_MSG, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(INTERNAL_ERROR_MSG, e);
        }
    }

    static {
        CONV_LONG.put(Integer.class, LONG_TO_INT);
        CONV_LONG.put(Long.class, new NoOpConverter());
        CONV_LONG.put(int[].class, LONG_TO_INT_ARRAY);
        CONV_LONG.put(long[].class, LONG_TO_LONG_ARRAY);
        CONV_INT.put(Integer.class, new NoOpConverter());
        CONV_INT.put(Long.class, INT_TO_LONG);
        CONV_INT.put(int[].class, new SeedConverterComposer<Integer, Long, int[]>(INT_TO_LONG, LONG_TO_INT_ARRAY));
        CONV_INT.put(long[].class, new SeedConverterComposer<Integer, Long, long[]>(INT_TO_LONG, LONG_TO_LONG_ARRAY));
        CONV_INT_ARRAY.put(Integer.class, INT_ARRAY_TO_INT);
        CONV_INT_ARRAY.put(Long.class, new SeedConverterComposer<int[], Integer, Long>(INT_ARRAY_TO_INT, INT_TO_LONG));
        CONV_INT_ARRAY.put(int[].class, new NoOpConverter());
        CONV_INT_ARRAY.put(long[].class, INT_ARRAY_TO_LONG_ARRAY);
        CONV_LONG_ARRAY.put(Integer.class, new SeedConverterComposer<long[], Long, Integer>(LONG_ARRAY_TO_LONG, LONG_TO_INT));
        CONV_LONG_ARRAY.put(Long.class, LONG_ARRAY_TO_LONG);
        CONV_LONG_ARRAY.put(int[].class, LONG_ARRAY_TO_INT_ARRAY);
        CONV_LONG_ARRAY.put(long[].class, new NoOpConverter());
        CONV_BYTE_ARRAY.put(Integer.class, new SeedConverterComposer<byte[], int[], Integer>(BYTE_ARRAY_TO_INT_ARRAY, INT_ARRAY_TO_INT));
        CONV_BYTE_ARRAY.put(Long.class, new SeedConverterComposer<byte[], long[], Long>(BYTE_ARRAY_TO_LONG_ARRAY, LONG_ARRAY_TO_LONG));
        CONV_BYTE_ARRAY.put(int[].class, BYTE_ARRAY_TO_INT_ARRAY);
        CONV_BYTE_ARRAY.put(long[].class, BYTE_ARRAY_TO_LONG_ARRAY);
    }

    public static enum RandomSourceInternal {
        JDK(JDKRandom.class, Long.class),
        WELL_512_A(Well512a.class, int[].class),
        WELL_1024_A(Well1024a.class, int[].class),
        WELL_19937_A(Well19937a.class, int[].class),
        WELL_19937_C(Well19937c.class, int[].class),
        WELL_44497_A(Well44497a.class, int[].class),
        WELL_44497_B(Well44497b.class, int[].class),
        MT(MersenneTwister.class, int[].class),
        ISAAC(ISAACRandom.class, int[].class),
        SPLIT_MIX_64(SplitMix64.class, Long.class),
        XOR_SHIFT_1024_S(XorShift1024Star.class, long[].class),
        TWO_CMRES(TwoCmres.class, Integer.class),
        TWO_CMRES_SELECT(TwoCmres.class, Integer.class, Integer.TYPE, Integer.TYPE),
        MT_64(MersenneTwister64.class, long[].class),
        MWC_256(MultiplyWithCarry256.class, int[].class),
        KISS(KISSRandom.class, int[].class);

        private final Class<? extends UniformRandomProvider> rng;
        private final Class<?>[] args;

        private RandomSourceInternal(Class<? extends UniformRandomProvider> rng, Class<?> ... args) {
            this.rng = rng;
            this.args = Arrays.copyOf(args, args.length);
        }

        public Class<?> getRng() {
            return this.rng;
        }

        Class<?> getSeed() {
            return this.args[0];
        }

        Class<?>[] getArgs() {
            return this.args;
        }

        public <SEED> boolean isNativeSeed(SEED seed) {
            return seed == null ? false : this.getSeed().equals(seed.getClass());
        }
    }
}

