/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.distribution;

import io.virtdata.shaded.oac.statistics.distribution.DiscreteDistribution;
import java.io.Serializable;
import org.apache.commons.math4.distribution.IntegerDistribution;
import org.apache.commons.math4.exception.MathInternalError;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteInverseCumulativeProbabilityFunction;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.InverseTransformDiscreteSampler;

public abstract class AbstractIntegerDistribution
implements IntegerDistribution,
Serializable {
    private static final long serialVersionUID = 20160318L;

    @Override
    public double probability(int x0, int x1) throws NumberIsTooLargeException {
        if (x1 < x0) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_ENDPOINT_ABOVE_UPPER_ENDPOINT, (Number)x0, x1, true);
        }
        return this.cumulativeProbability(x1) - this.cumulativeProbability(x0);
    }

    @Override
    public int inverseCumulativeProbability(double p) throws OutOfRangeException {
        boolean chebyshevApplies;
        if (p < 0.0 || p > 1.0) {
            throw new OutOfRangeException(p, (Number)0, 1);
        }
        int lower = this.getSupportLowerBound();
        if (p == 0.0) {
            return lower;
        }
        if (lower == Integer.MIN_VALUE) {
            if (this.checkedCumulativeProbability(lower) >= p) {
                return lower;
            }
        } else {
            --lower;
        }
        int upper = this.getSupportUpperBound();
        if (p == 1.0) {
            return upper;
        }
        double mu = this.getMean();
        double sigma = FastMath.sqrt(this.getVariance());
        boolean bl = chebyshevApplies = !Double.isInfinite(mu) && !Double.isNaN(mu) && !Double.isInfinite(sigma) && !Double.isNaN(sigma) && sigma != 0.0;
        if (chebyshevApplies) {
            double k = FastMath.sqrt((1.0 - p) / p);
            double tmp = mu - k * sigma;
            if (tmp > (double)lower) {
                lower = (int)FastMath.ceil(tmp) - 1;
            }
            if ((tmp = mu + (k = 1.0 / k) * sigma) < (double)upper) {
                upper = (int)FastMath.ceil(tmp) - 1;
            }
        }
        return this.solveInverseCumulativeProbability(p, lower, upper);
    }

    protected int solveInverseCumulativeProbability(double p, int lower, int upper) {
        while (lower + 1 < upper) {
            double pm;
            int xm = (lower + upper) / 2;
            if (xm < lower || xm > upper) {
                xm = lower + (upper - lower) / 2;
            }
            if ((pm = this.checkedCumulativeProbability(xm)) >= p) {
                upper = xm;
                continue;
            }
            lower = xm;
        }
        return upper;
    }

    private double checkedCumulativeProbability(int argument) throws MathInternalError {
        double result = this.cumulativeProbability(argument);
        if (Double.isNaN(result)) {
            throw new MathInternalError(LocalizedFormats.DISCRETE_CUMULATIVE_PROBABILITY_RETURNED_NAN, argument);
        }
        return result;
    }

    @Override
    public double logProbability(int x) {
        return FastMath.log(this.probability(x));
    }

    public static int[] sample(int n, DiscreteDistribution.Sampler sampler) {
        int[] samples = new int[n];
        for (int i = 0; i < n; ++i) {
            samples[i] = sampler.sample();
        }
        return samples;
    }

    @Override
    public DiscreteDistribution.Sampler createSampler(final UniformRandomProvider rng) {
        return new DiscreteDistribution.Sampler(){
            private final DiscreteSampler sampler;
            {
                this.sampler = new InverseTransformDiscreteSampler(rng, AbstractIntegerDistribution.this.createICPF());
            }

            @Override
            public int sample() {
                return this.sampler.sample();
            }
        };
    }

    private DiscreteInverseCumulativeProbabilityFunction createICPF() {
        return new DiscreteInverseCumulativeProbabilityFunction(){

            @Override
            public int inverseCumulativeProbability(double p) {
                return AbstractIntegerDistribution.this.inverseCumulativeProbability(p);
            }
        };
    }
}

