/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.geometry.partitioning;

import org.apache.commons.math4.geometry.Space;
import org.apache.commons.math4.geometry.partitioning.BSPTree;
import org.apache.commons.math4.geometry.partitioning.BSPTreeVisitor;
import org.apache.commons.math4.geometry.partitioning.BoundaryAttribute;

class BoundarySizeVisitor<S extends Space>
implements BSPTreeVisitor<S> {
    private double boundarySize = 0.0;

    BoundarySizeVisitor() {
    }

    @Override
    public BSPTreeVisitor.Order visitOrder(BSPTree<S> node) {
        return BSPTreeVisitor.Order.MINUS_SUB_PLUS;
    }

    @Override
    public void visitInternalNode(BSPTree<S> node) {
        BoundaryAttribute attribute = (BoundaryAttribute)node.getAttribute();
        if (attribute.getPlusOutside() != null) {
            this.boundarySize += attribute.getPlusOutside().getSize();
        }
        if (attribute.getPlusInside() != null) {
            this.boundarySize += attribute.getPlusInside().getSize();
        }
    }

    @Override
    public void visitLeafNode(BSPTree<S> node) {
    }

    public double getSize() {
        return this.boundarySize;
    }
}

