/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.MathUtils;

public class Frequency<T extends Comparable<T>>
implements Serializable {
    private static final long serialVersionUID = 605878194679954450L;
    private final SortedMap<T, Long> freqTable;

    public Frequency() {
        this.freqTable = new TreeMap<T, Long>();
    }

    public Frequency(Comparator<T> comparator) {
        this.freqTable = new TreeMap<T, Long>(comparator);
    }

    public String toString() {
        NumberFormat nf = NumberFormat.getPercentInstance();
        StringBuilder outBuffer = new StringBuilder();
        outBuffer.append("Value \t Freq. \t Pct. \t Cum Pct. \n");
        for (Comparable value : this.freqTable.keySet()) {
            outBuffer.append(value);
            outBuffer.append('\t');
            outBuffer.append(this.getCount(value));
            outBuffer.append('\t');
            outBuffer.append(nf.format(this.getPct(value)));
            outBuffer.append('\t');
            outBuffer.append(nf.format(this.getCumPct(value)));
            outBuffer.append('\n');
        }
        return outBuffer.toString();
    }

    public void addValue(T v) {
        this.incrementValue(v, 1L);
    }

    public void incrementValue(T v, long increment) {
        Long count = (Long)this.freqTable.get(v);
        if (count == null) {
            this.freqTable.put(v, increment);
        } else {
            this.freqTable.put(v, count + increment);
        }
    }

    public void clear() {
        this.freqTable.clear();
    }

    public Iterator<T> valuesIterator() {
        return this.freqTable.keySet().iterator();
    }

    public Iterator<Map.Entry<T, Long>> entrySetIterator() {
        return this.freqTable.entrySet().iterator();
    }

    public long getSumFreq() {
        long result = 0L;
        Iterator<Long> iterator = this.freqTable.values().iterator();
        while (iterator.hasNext()) {
            result += iterator.next().longValue();
        }
        return result;
    }

    public long getCount(T v) {
        long result = 0L;
        Long count = (Long)this.freqTable.get(v);
        if (count != null) {
            result = count;
        }
        return result;
    }

    public int getUniqueCount() {
        return this.freqTable.keySet().size();
    }

    public double getPct(T v) {
        long sumFreq = this.getSumFreq();
        if (sumFreq == 0L) {
            return Double.NaN;
        }
        return (double)this.getCount(v) / (double)sumFreq;
    }

    public long getCumFreq(T v) {
        if (this.getSumFreq() == 0L) {
            return 0L;
        }
        Comparator<T> c = this.freqTable.comparator();
        if (c == null) {
            c = new NaturalComparator<T>();
        }
        long result = 0L;
        Long value = (Long)this.freqTable.get(v);
        if (value != null) {
            result = value;
        }
        if (c.compare(v, this.freqTable.firstKey()) < 0) {
            return 0L;
        }
        if (c.compare(v, this.freqTable.lastKey()) >= 0) {
            return this.getSumFreq();
        }
        Iterator<T> values = this.valuesIterator();
        while (values.hasNext()) {
            Comparable nextValue = (Comparable)values.next();
            if (c.compare(v, nextValue) > 0) {
                result += this.getCount(nextValue);
                continue;
            }
            return result;
        }
        return result;
    }

    public double getCumPct(T v) {
        long sumFreq = this.getSumFreq();
        if (sumFreq == 0L) {
            return Double.NaN;
        }
        return (double)this.getCumFreq(v) / (double)sumFreq;
    }

    public List<T> getMode() {
        long mostPopular = 0L;
        for (Long l : this.freqTable.values()) {
            long frequency = l;
            if (frequency <= mostPopular) continue;
            mostPopular = frequency;
        }
        ArrayList<T> modeList = new ArrayList<T>();
        for (Map.Entry<T, Long> ent : this.freqTable.entrySet()) {
            long frequency = ent.getValue();
            if (frequency != mostPopular) continue;
            modeList.add(ent.getKey());
        }
        return modeList;
    }

    public void merge(Frequency<T> other) throws NullArgumentException {
        MathUtils.checkNotNull(other, LocalizedFormats.NULL_NOT_ALLOWED, new Object[0]);
        Iterator<Map.Entry<T, Long>> iter = other.entrySetIterator();
        while (iter.hasNext()) {
            Map.Entry<T, Long> entry = iter.next();
            this.incrementValue((Comparable)entry.getKey(), entry.getValue());
        }
    }

    public void merge(Collection<Frequency<T>> others) throws NullArgumentException {
        MathUtils.checkNotNull(others, LocalizedFormats.NULL_NOT_ALLOWED, new Object[0]);
        for (Frequency<T> freq : others) {
            this.merge(freq);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.freqTable == null ? 0 : this.freqTable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Frequency)) {
            return false;
        }
        Frequency other = (Frequency)obj;
        return !(this.freqTable == null ? other.freqTable != null : !this.freqTable.equals(other.freqTable));
    }

    private static class NaturalComparator<U extends Comparable<U>>
    implements Comparator<U>,
    Serializable {
        private static final long serialVersionUID = -3852193713161395148L;

        private NaturalComparator() {
        }

        @Override
        public int compare(U o1, U o2) {
            return o1.compareTo(o2);
        }
    }
}

