/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.rng.UniformRandomProvider;

public interface ContinuousDistribution {
    default public double probability(double x) {
        return 0.0;
    }

    default public double probability(double x0, double x1) {
        if (x0 > x1) {
            throw new DistributionException("{0} > {1}", x0, x1);
        }
        return this.cumulativeProbability(x1) - this.cumulativeProbability(x0);
    }

    public double density(double var1);

    default public double logDensity(double x) {
        return Math.log(this.density(x));
    }

    public double cumulativeProbability(double var1);

    public double inverseCumulativeProbability(double var1);

    public double getMean();

    public double getVariance();

    public double getSupportLowerBound();

    public double getSupportUpperBound();

    public boolean isSupportConnected();

    public Sampler createSampler(UniformRandomProvider var1);

    public static interface Sampler {
        public double sample();
    }
}

