/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.distribution;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math4.distribution.AbstractMultivariateRealDistribution;
import org.apache.commons.math4.distribution.MultivariateRealDistribution;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.MathArithmeticException;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.Pair;
import org.apache.commons.rng.UniformRandomProvider;

public class MixtureMultivariateRealDistribution<T extends MultivariateRealDistribution>
extends AbstractMultivariateRealDistribution {
    private final double[] weight;
    private final List<T> distribution;

    public MixtureMultivariateRealDistribution(List<Pair<Double, T>> components) {
        super(((MultivariateRealDistribution)components.get(0).getSecond()).getDimension());
        Pair<Double, T> comp;
        int i;
        int numComp = components.size();
        int dim = this.getDimension();
        double weightSum = 0.0;
        for (i = 0; i < numComp; ++i) {
            comp = components.get(i);
            if (((MultivariateRealDistribution)comp.getSecond()).getDimension() != dim) {
                throw new DimensionMismatchException(((MultivariateRealDistribution)comp.getSecond()).getDimension(), dim);
            }
            if (comp.getFirst() < 0.0) {
                throw new NotPositiveException(comp.getFirst());
            }
            weightSum += comp.getFirst().doubleValue();
        }
        if (Double.isInfinite(weightSum)) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        this.distribution = new ArrayList<T>();
        this.weight = new double[numComp];
        for (i = 0; i < numComp; ++i) {
            comp = components.get(i);
            this.weight[i] = comp.getFirst() / weightSum;
            this.distribution.add(comp.getSecond());
        }
    }

    @Override
    public double density(double[] values) {
        double p = 0.0;
        for (int i = 0; i < this.weight.length; ++i) {
            p += this.weight[i] * ((MultivariateRealDistribution)this.distribution.get(i)).density(values);
        }
        return p;
    }

    public List<Pair<Double, T>> getComponents() {
        ArrayList<Pair<Double, T>> list = new ArrayList<Pair<Double, T>>(this.weight.length);
        for (int i = 0; i < this.weight.length; ++i) {
            list.add(new Pair<Double, T>(this.weight[i], this.distribution.get(i)));
        }
        return list;
    }

    @Override
    public MultivariateRealDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return new MixtureSampler(rng);
    }

    private class MixtureSampler
    implements MultivariateRealDistribution.Sampler {
        private final UniformRandomProvider rng;
        private final MultivariateRealDistribution.Sampler[] samplers;

        MixtureSampler(UniformRandomProvider generator) {
            this.rng = generator;
            this.samplers = new MultivariateRealDistribution.Sampler[MixtureMultivariateRealDistribution.this.weight.length];
            for (int i = 0; i < MixtureMultivariateRealDistribution.this.weight.length; ++i) {
                this.samplers[i] = ((MultivariateRealDistribution)MixtureMultivariateRealDistribution.this.distribution.get(i)).createSampler(this.rng);
            }
        }

        @Override
        public double[] sample() {
            double[] vals = null;
            double randomValue = this.rng.nextDouble();
            double sum = 0.0;
            for (int i = 0; i < MixtureMultivariateRealDistribution.this.weight.length; ++i) {
                if (!(randomValue <= (sum += MixtureMultivariateRealDistribution.this.weight[i]))) continue;
                vals = this.samplers[i].sample();
                break;
            }
            if (vals == null) {
                vals = this.samplers[MixtureMultivariateRealDistribution.this.weight.length - 1].sample();
            }
            return vals;
        }
    }
}

