/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.descriptive.moment;

import io.virtdata.shaded.oac.statistics.descriptive.AbstractStorelessUnivariateStatistic;
import io.virtdata.shaded.oac.statistics.descriptive.StorelessUnivariateStatistic;
import io.virtdata.shaded.oac.statistics.descriptive.summary.SumOfLogs;
import java.io.Serializable;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.MathIllegalStateException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathUtils;

public class GeometricMean
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 20150412L;
    private StorelessUnivariateStatistic sumOfLogs;

    public GeometricMean() {
        this.sumOfLogs = new SumOfLogs();
    }

    public GeometricMean(GeometricMean original) throws NullArgumentException {
        GeometricMean.copy(original, this);
    }

    public GeometricMean(SumOfLogs sumOfLogs) {
        this.sumOfLogs = sumOfLogs;
    }

    @Override
    public GeometricMean copy() {
        GeometricMean result = new GeometricMean();
        GeometricMean.copy(this, result);
        return result;
    }

    @Override
    public void increment(double d) {
        this.sumOfLogs.increment(d);
    }

    @Override
    public double getResult() {
        if (this.sumOfLogs.getN() > 0L) {
            return FastMath.exp(this.sumOfLogs.getResult() / (double)this.sumOfLogs.getN());
        }
        return Double.NaN;
    }

    @Override
    public void clear() {
        this.sumOfLogs.clear();
    }

    @Override
    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        return FastMath.exp(this.sumOfLogs.evaluate(values, begin, length) / (double)length);
    }

    @Override
    public long getN() {
        return this.sumOfLogs.getN();
    }

    public void setSumLogImpl(StorelessUnivariateStatistic sumLogImpl) throws MathIllegalStateException {
        this.checkEmpty();
        this.sumOfLogs = sumLogImpl;
    }

    public StorelessUnivariateStatistic getSumLogImpl() {
        return this.sumOfLogs;
    }

    public static void copy(GeometricMean source, GeometricMean dest) throws NullArgumentException {
        MathUtils.checkNotNull(source);
        MathUtils.checkNotNull(dest);
        dest.sumOfLogs = source.sumOfLogs.copy();
    }

    private void checkEmpty() throws MathIllegalStateException {
        if (this.getN() > 0L) {
            throw new MathIllegalStateException(LocalizedFormats.VALUES_ADDED_BEFORE_CONFIGURING_STATISTIC, this.getN());
        }
    }
}

