/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.ContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.numbers.gamma.LogGamma;
import org.apache.commons.numbers.gamma.RegularizedBeta;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ChengBetaSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;

public class BetaDistribution
extends AbstractContinuousDistribution {
    private final double alpha;
    private final double beta;
    private final double z;

    public BetaDistribution(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
        this.z = LogGamma.value(alpha) + LogGamma.value(beta) - LogGamma.value(alpha + beta);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    @Override
    public double density(double x) {
        double logDensity = this.logDensity(x);
        return logDensity == Double.NEGATIVE_INFINITY ? 0.0 : Math.exp(logDensity);
    }

    @Override
    public double logDensity(double x) {
        if (x < 0.0 || x > 1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (x == 0.0) {
            if (this.alpha < 1.0) {
                throw new DistributionException("{0} < {1}", this.alpha, 1);
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (x == 1.0) {
            if (this.beta < 1.0) {
                throw new DistributionException("{0} < {1}", this.beta, 1);
            }
            return Double.NEGATIVE_INFINITY;
        }
        double logX = Math.log(x);
        double log1mX = Math.log1p(-x);
        return (this.alpha - 1.0) * logX + (this.beta - 1.0) * log1mX - this.z;
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 1.0) {
            return 1.0;
        }
        return RegularizedBeta.value(x, this.alpha, this.beta);
    }

    @Override
    public double getMean() {
        double a = this.getAlpha();
        return a / (a + this.getBeta());
    }

    @Override
    public double getVariance() {
        double a = this.getAlpha();
        double b = this.getBeta();
        double alphabetasum = a + b;
        return a * b / (alphabetasum * alphabetasum * (alphabetasum + 1.0));
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return 1.0;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(final UniformRandomProvider rng) {
        return new ContinuousDistribution.Sampler(){
            private final ContinuousSampler sampler;
            {
                this.sampler = new ChengBetaSampler(rng, BetaDistribution.this.alpha, BetaDistribution.this.beta);
            }

            @Override
            public double sample() {
                return this.sampler.sample();
            }
        };
    }
}

