/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.geometry.partitioning;

import org.apache.commons.math4.geometry.Space;
import org.apache.commons.math4.geometry.partitioning.Hyperplane;
import org.apache.commons.math4.geometry.partitioning.Side;

public interface SubHyperplane<S extends Space> {
    public SubHyperplane<S> copySelf();

    public Hyperplane<S> getHyperplane();

    public boolean isEmpty();

    public double getSize();

    public SplitSubHyperplane<S> split(Hyperplane<S> var1);

    public SubHyperplane<S> reunite(SubHyperplane<S> var1);

    public static class SplitSubHyperplane<U extends Space> {
        private final SubHyperplane<U> plus;
        private final SubHyperplane<U> minus;

        public SplitSubHyperplane(SubHyperplane<U> plus, SubHyperplane<U> minus) {
            this.plus = plus;
            this.minus = minus;
        }

        public SubHyperplane<U> getPlus() {
            return this.plus;
        }

        public SubHyperplane<U> getMinus() {
            return this.minus;
        }

        public Side getSide() {
            if (this.plus != null && !this.plus.isEmpty()) {
                if (this.minus != null && !this.minus.isEmpty()) {
                    return Side.BOTH;
                }
                return Side.PLUS;
            }
            if (this.minus != null && !this.minus.isEmpty()) {
                return Side.MINUS;
            }
            return Side.HYPER;
        }
    }
}

