/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.arrays;

public class SafeNorm {
    private static final double R_DWARF = 3.834E-20;
    private static final double R_GIANT = 1.304E19;

    public static double value(double[] v) {
        double s1 = 0.0;
        double s2 = 0.0;
        double s3 = 0.0;
        double x1max = 0.0;
        double x3max = 0.0;
        double floatn = v.length;
        double agiant = 1.304E19 / floatn;
        for (int i = 0; i < v.length; ++i) {
            double xabs = Math.abs(v[i]);
            if (xabs < 3.834E-20 || xabs > agiant) {
                double r;
                if (xabs > 3.834E-20) {
                    if (xabs > x1max) {
                        r = x1max / xabs;
                        s1 = 1.0 + s1 * r * r;
                        x1max = xabs;
                        continue;
                    }
                    r = xabs / x1max;
                    s1 += r * r;
                    continue;
                }
                if (xabs > x3max) {
                    r = x3max / xabs;
                    s3 = 1.0 + s3 * r * r;
                    x3max = xabs;
                    continue;
                }
                if (xabs == 0.0) continue;
                r = xabs / x3max;
                s3 += r * r;
                continue;
            }
            s2 += xabs * xabs;
        }
        double norm = s1 != 0.0 ? x1max * Math.sqrt(s1 + s2 / x1max / x1max) : (s2 == 0.0 ? x3max * Math.sqrt(s3) : (s2 >= x3max ? Math.sqrt(s2 * (1.0 + x3max / s2 * (x3max * s3))) : Math.sqrt(x3max * (s2 / x3max + x3max * s3))));
        return norm;
    }
}

