/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;

public class CauchyDistribution
extends AbstractContinuousDistribution {
    private final double median;
    private final double scale;

    public CauchyDistribution(double median, double scale) {
        if (scale <= 0.0) {
            throw new DistributionException("Number {0} is negative", scale);
        }
        this.scale = scale;
        this.median = median;
    }

    @Override
    public double cumulativeProbability(double x) {
        return 0.5 + Math.atan((x - this.median) / this.scale) / Math.PI;
    }

    public double getMedian() {
        return this.median;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public double density(double x) {
        double dev = x - this.median;
        return 0.3183098861837907 * (this.scale / (dev * dev + this.scale * this.scale));
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", p, 0, 1);
        }
        double ret = p == 0.0 ? Double.NEGATIVE_INFINITY : (p == 1.0 ? Double.POSITIVE_INFINITY : this.median + this.scale * Math.tan(Math.PI * (p - 0.5)));
        return ret;
    }

    @Override
    public double getMean() {
        return Double.NaN;
    }

    @Override
    public double getVariance() {
        return Double.NaN;
    }

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

