/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.interval;

import io.virtdata.shaded.oac.statistics.distribution.NormalDistribution;
import io.virtdata.shaded.oac.statistics.interval.BinomialConfidenceInterval;
import io.virtdata.shaded.oac.statistics.interval.ConfidenceInterval;
import io.virtdata.shaded.oac.statistics.interval.IntervalUtils;
import org.apache.commons.math4.util.FastMath;

public class NormalApproximationInterval
implements BinomialConfidenceInterval {
    @Override
    public ConfidenceInterval createInterval(int numberOfTrials, int numberOfSuccesses, double confidenceLevel) {
        IntervalUtils.checkParameters(numberOfTrials, numberOfSuccesses, confidenceLevel);
        double mean = (double)numberOfSuccesses / (double)numberOfTrials;
        double alpha = (1.0 - confidenceLevel) / 2.0;
        NormalDistribution normalDistribution = new NormalDistribution(0.0, 1.0);
        double difference = normalDistribution.inverseCumulativeProbability(1.0 - alpha) * FastMath.sqrt(1.0 / (double)numberOfTrials * mean * (1.0 - mean));
        return new ConfidenceInterval(mean - difference, mean + difference, confidenceLevel);
    }
}

