/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.discrete.common;

import io.virtdata.discrete.common.ThreadSafeHash;
import java.util.function.DoubleToIntFunction;
import java.util.function.IntUnaryOperator;

public class DiscreteIntIntSampler
implements IntUnaryOperator {
    private final DoubleToIntFunction f;
    private ThreadSafeHash hash;

    public DiscreteIntIntSampler(DoubleToIntFunction parentFunc, boolean hash) {
        this.f = parentFunc;
        if (hash) {
            this.hash = new ThreadSafeHash();
        }
    }

    @Override
    public int applyAsInt(int value) {
        if (this.hash != null) {
            value = (int)this.hash.applyAsLong(value);
        }
        double unit = (double)value / 9.223372036854776E18;
        int sample = this.f.applyAsInt(unit);
        return sample;
    }
}

