/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.ContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.numbers.gamma.Erf;
import org.apache.commons.numbers.gamma.ErfDifference;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.LogNormalSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratNormalizedGaussianSampler;

public class LogNormalDistribution
extends AbstractContinuousDistribution {
    private static final double SQRT2PI = Math.sqrt(Math.PI * 2);
    private static final double SQRT2 = Math.sqrt(2.0);
    private final double scale;
    private final double shape;
    private final double logShapePlusHalfLog2Pi;

    public LogNormalDistribution(double scale, double shape) {
        if (shape <= 0.0) {
            throw new DistributionException("Number {0} is negative", shape);
        }
        this.scale = scale;
        this.shape = shape;
        this.logShapePlusHalfLog2Pi = Math.log(shape) + 0.5 * Math.log(Math.PI * 2);
    }

    public double getScale() {
        return this.scale;
    }

    public double getShape() {
        return this.shape;
    }

    @Override
    public double density(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double x0 = Math.log(x) - this.scale;
        double x1 = x0 / this.shape;
        return Math.exp(-0.5 * x1 * x1) / (this.shape * SQRT2PI * x);
    }

    @Override
    public double logDensity(double x) {
        if (x <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double logX = Math.log(x);
        double x0 = logX - this.scale;
        double x1 = x0 / this.shape;
        return -0.5 * x1 * x1 - (this.logShapePlusHalfLog2Pi + logX);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double dev = Math.log(x) - this.scale;
        if (Math.abs(dev) > 40.0 * this.shape) {
            return dev < 0.0 ? 0.0 : 1.0;
        }
        return 0.5 + 0.5 * Erf.value(dev / (this.shape * SQRT2));
    }

    @Override
    public double probability(double x0, double x1) {
        if (x0 > x1) {
            throw new DistributionException("{0} > {1}", x0, x1);
        }
        if (x0 <= 0.0 || x1 <= 0.0) {
            return super.probability(x0, x1);
        }
        double denom = this.shape * SQRT2;
        double v0 = (Math.log(x0) - this.scale) / denom;
        double v1 = (Math.log(x1) - this.scale) / denom;
        return 0.5 * ErfDifference.value(v0, v1);
    }

    @Override
    public double getMean() {
        double s = this.shape;
        return Math.exp(this.scale + s * s / 2.0);
    }

    @Override
    public double getVariance() {
        double s = this.shape;
        double ss = s * s;
        return Math.expm1(ss) * Math.exp(2.0 * this.scale + ss);
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(final UniformRandomProvider rng) {
        return new ContinuousDistribution.Sampler(){
            private final ContinuousSampler sampler;
            {
                this.sampler = new LogNormalSampler(new ZigguratNormalizedGaussianSampler(rng), LogNormalDistribution.this.scale, LogNormalDistribution.this.shape);
            }

            @Override
            public double sample() {
                return this.sampler.sample();
            }
        };
    }
}

