/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.geometry.euclidean.twod.hull;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math4.geometry.euclidean.twod.Cartesian2D;

public final class AklToussaintHeuristic {
    private AklToussaintHeuristic() {
    }

    public static Collection<Cartesian2D> reducePoints(Collection<Cartesian2D> points) {
        int size = 0;
        Cartesian2D minX = null;
        Cartesian2D maxX = null;
        Cartesian2D minY = null;
        Cartesian2D maxY = null;
        for (Cartesian2D p : points) {
            if (minX == null || p.getX() < minX.getX()) {
                minX = p;
            }
            if (maxX == null || p.getX() > maxX.getX()) {
                maxX = p;
            }
            if (minY == null || p.getY() < minY.getY()) {
                minY = p;
            }
            if (maxY == null || p.getY() > maxY.getY()) {
                maxY = p;
            }
            ++size;
        }
        if (size < 4) {
            return points;
        }
        List<Cartesian2D> quadrilateral = AklToussaintHeuristic.buildQuadrilateral(minY, maxX, maxY, minX);
        if (quadrilateral.size() < 3) {
            return points;
        }
        ArrayList<Cartesian2D> reducedPoints = new ArrayList<Cartesian2D>(quadrilateral);
        for (Cartesian2D p : points) {
            if (AklToussaintHeuristic.insideQuadrilateral(p, quadrilateral)) continue;
            reducedPoints.add(p);
        }
        return reducedPoints;
    }

    private static List<Cartesian2D> buildQuadrilateral(Cartesian2D ... points) {
        ArrayList<Cartesian2D> quadrilateral = new ArrayList<Cartesian2D>();
        for (Cartesian2D p : points) {
            if (quadrilateral.contains(p)) continue;
            quadrilateral.add(p);
        }
        return quadrilateral;
    }

    private static boolean insideQuadrilateral(Cartesian2D point, List<Cartesian2D> quadrilateralPoints) {
        Cartesian2D p1 = quadrilateralPoints.get(0);
        Cartesian2D p2 = quadrilateralPoints.get(1);
        if (point.equals(p1) || point.equals(p2)) {
            return true;
        }
        double last = point.crossProduct(p1, p2);
        int size = quadrilateralPoints.size();
        for (int i = 1; i < size; ++i) {
            p1 = p2;
            p2 = quadrilateralPoints.get(i + 1 == size ? 0 : i + 1);
            if (point.equals(p1) || point.equals(p2)) {
                return true;
            }
            if (!(last * point.crossProduct(p1, p2) < 0.0)) continue;
            return false;
        }
        return true;
    }
}

