/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.complex;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.numbers.core.Precision;

public final class Complex
implements Serializable {
    public static final Complex I = new Complex(0.0, 1.0);
    public static final Complex INF = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final Complex ONE = new Complex(1.0, 0.0);
    public static final Complex ZERO = new Complex(0.0, 0.0);
    private static final Complex NAN = new Complex(Double.NaN, Double.NaN);
    private static final long serialVersionUID = 20180201L;
    private static final String FORMAT_START = "(";
    private static final String FORMAT_END = ")";
    private static final String FORMAT_SEP = ",";
    private final double imaginary;
    private final double real;

    private Complex(double real, double imaginary) {
        this.real = real;
        this.imaginary = imaginary;
    }

    public static Complex ofCartesian(double real, double imaginary) {
        return new Complex(real, imaginary);
    }

    public static Complex ofReal(double real) {
        return new Complex(real, 0.0);
    }

    public static Complex ofPolar(double r, double theta) {
        Complex.checkNotNegative(r);
        return new Complex(r * Math.cos(theta), r * Math.sin(theta));
    }

    public static Complex ofCis(double x) {
        return new Complex(Math.cos(x), Math.sin(x));
    }

    public static Complex parse(String s) {
        double im;
        double re;
        int len = s.length();
        int startParen = s.indexOf(FORMAT_START);
        if (startParen != 0) {
            throw new ComplexParsingException("Expected start string: (");
        }
        int endParen = s.indexOf(FORMAT_END);
        if (endParen != len - 1) {
            throw new ComplexParsingException("Expected end string: )");
        }
        String[] elements = s.substring(1, s.length() - 1).split(FORMAT_SEP);
        if (elements.length != 2) {
            throw new ComplexParsingException("Incorrect number of parts: Expected 2 but was " + elements.length + " (separator is '" + FORMAT_SEP + "')");
        }
        try {
            re = Double.parseDouble(elements[0]);
        }
        catch (NumberFormatException ex) {
            throw new ComplexParsingException("Could not parse real part" + elements[0]);
        }
        try {
            im = Double.parseDouble(elements[1]);
        }
        catch (NumberFormatException ex) {
            throw new ComplexParsingException("Could not parse imaginary part" + elements[1]);
        }
        return Complex.ofCartesian(re, im);
    }

    public boolean isNaN() {
        return Double.isNaN(this.real) || Double.isNaN(this.imaginary);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.real) || Double.isInfinite(this.imaginary);
    }

    public Complex proj() {
        if (Double.isInfinite(this.real) || Double.isInfinite(this.imaginary)) {
            return new Complex(Double.POSITIVE_INFINITY, 0.0);
        }
        return this;
    }

    public double abs() {
        if (Math.abs(this.real) < Math.abs(this.imaginary)) {
            double q = this.real / this.imaginary;
            return Math.abs(this.imaginary) * Math.sqrt(1.0 + q * q);
        }
        if (this.real == 0.0) {
            return Math.abs(this.imaginary);
        }
        double q = this.imaginary / this.real;
        return Math.abs(this.real) * Math.sqrt(1.0 + q * q);
    }

    public Complex add(Complex addend) {
        return new Complex(this.real + addend.real, this.imaginary + addend.imaginary);
    }

    public Complex add(double addend) {
        return new Complex(this.real + addend, this.imaginary);
    }

    public Complex conjugate() {
        return new Complex(this.real, -this.imaginary);
    }

    public Complex conj() {
        return this.conjugate();
    }

    public Complex divide(Complex divisor) {
        double a = this.real;
        double b = this.imaginary;
        double c = divisor.getReal();
        double d = divisor.getImaginary();
        int ilogbw = 0;
        double logbw = Math.log(Math.max(Math.abs(c), Math.abs(d))) / Math.log(2.0);
        if (!Double.isInfinite(logbw)) {
            ilogbw = (int)logbw;
            c = Math.scalb(c, -ilogbw);
            d = Math.scalb(d, -ilogbw);
        }
        double denom = c * c + d * d;
        double x = Math.scalb((a * c + b * d) / denom, -ilogbw);
        double y = Math.scalb((b * c - a * d) / denom, -ilogbw);
        if (Double.isNaN(x) && Double.isNaN(y)) {
            if (!(denom != 0.0 || Double.isNaN(a) && Double.isNaN(b))) {
                x = Math.copySign(Double.POSITIVE_INFINITY, c) * a;
                y = Math.copySign(Double.POSITIVE_INFINITY, c) * b;
            } else if (Double.isInfinite(a) && Double.isInfinite(b) && !Double.isInfinite(c) && !Double.isInfinite(d)) {
                a = Math.copySign(Double.isInfinite(a) ? 1.0 : 0.0, a);
                b = Math.copySign(Double.isInfinite(b) ? 1.0 : 0.0, b);
                x = Double.POSITIVE_INFINITY * (a * c + b * d);
                y = Double.POSITIVE_INFINITY * (b * c - a * d);
            } else if (Double.isInfinite(logbw) && !Double.isInfinite(a) && !Double.isInfinite(b)) {
                c = Math.copySign(Double.isInfinite(c) ? 1.0 : 0.0, c);
                d = Math.copySign(Double.isInfinite(d) ? 1.0 : 0.0, d);
                x = 0.0 * (a * c + b * d);
                y = 0.0 * (b * c - a * d);
            }
        }
        return new Complex(x, y);
    }

    public Complex divide(double divisor) {
        return this.divide(new Complex(divisor, 0.0));
    }

    public Complex reciprocal() {
        if (Math.abs(this.real) < Math.abs(this.imaginary)) {
            double q = this.real / this.imaginary;
            double scale = 1.0 / (this.real * q + this.imaginary);
            double scaleQ = 0.0;
            if (q != 0.0 && scale != 0.0) {
                scaleQ = scale * q;
            }
            return new Complex(scaleQ, -scale);
        }
        double q = this.imaginary / this.real;
        double scale = 1.0 / (this.imaginary * q + this.real);
        double scaleQ = 0.0;
        if (q != 0.0 && scale != 0.0) {
            scaleQ = scale * q;
        }
        return new Complex(scale, -scaleQ);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Complex) {
            Complex c = (Complex)other;
            return Complex.equals(this.real, c.real) && Complex.equals(this.imaginary, c.imaginary);
        }
        return false;
    }

    public static boolean equals(Complex x, Complex y, int maxUlps) {
        return Precision.equals(x.real, y.real, maxUlps) && Precision.equals(x.imaginary, y.imaginary, maxUlps);
    }

    public static boolean equals(Complex x, Complex y) {
        return Complex.equals(x, y, 1);
    }

    public static boolean equals(Complex x, Complex y, double eps) {
        return Precision.equals(x.real, y.real, eps) && Precision.equals(x.imaginary, y.imaginary, eps);
    }

    public static boolean equalsWithRelativeTolerance(Complex x, Complex y, double eps) {
        return Precision.equalsWithRelativeTolerance(x.real, y.real, eps) && Precision.equalsWithRelativeTolerance(x.imaginary, y.imaginary, eps);
    }

    public int hashCode() {
        if (Double.isNaN(this.real) || Double.isNaN(this.imaginary)) {
            return 7;
        }
        return 37 * (17 * this.hash(this.imaginary) + this.hash(this.real));
    }

    private int hash(double d) {
        long v = Double.doubleToLongBits(d);
        return (int)(v ^ v >>> 32);
    }

    public double getImaginary() {
        return this.imaginary;
    }

    public double imag() {
        return this.imaginary;
    }

    public double getReal() {
        return this.real;
    }

    public double real() {
        return this.real;
    }

    public Complex multiply(Complex factor) {
        double a = this.real;
        double b = this.imaginary;
        double c = factor.getReal();
        double d = factor.getImaginary();
        double ac = a * c;
        double bd = b * d;
        double ad = a * d;
        double bc = b * c;
        double x = ac - bd;
        double y = ad + bc;
        if (Double.isNaN(a) && Double.isNaN(b)) {
            boolean recalc = false;
            if (Double.isInfinite(a) || Double.isInfinite(b)) {
                a = Math.copySign(Double.isInfinite(a) ? 1.0 : 0.0, a);
                b = Math.copySign(Double.isInfinite(a) ? 1.0 : 0.0, a);
                if (Double.isNaN(c)) {
                    c = Math.copySign(0.0, c);
                }
                if (Double.isNaN(d)) {
                    d = Math.copySign(0.0, d);
                }
                recalc = true;
            }
            if (Double.isInfinite(c) || Double.isInfinite(d)) {
                c = Math.copySign(Double.isInfinite(c) ? 1.0 : 0.0, c);
                d = Math.copySign(Double.isInfinite(d) ? 1.0 : 0.0, d);
                if (Double.isNaN(a)) {
                    a = Math.copySign(0.0, a);
                }
                if (Double.isNaN(b)) {
                    b = Math.copySign(0.0, b);
                }
                recalc = true;
            }
            if (!recalc && (Double.isInfinite(ac) || Double.isInfinite(bd) || Double.isInfinite(ad) || Double.isInfinite(bc))) {
                if (Double.isNaN(a)) {
                    a = Math.copySign(0.0, a);
                }
                if (Double.isNaN(b)) {
                    b = Math.copySign(0.0, b);
                }
                if (Double.isNaN(c)) {
                    c = Math.copySign(0.0, c);
                }
                if (Double.isNaN(d)) {
                    d = Math.copySign(0.0, d);
                }
                recalc = true;
            }
            if (recalc) {
                x = Double.POSITIVE_INFINITY * (a * c - b * d);
                y = Double.POSITIVE_INFINITY * (a * d + b * c);
            }
        }
        return new Complex(x, y);
    }

    public Complex multiply(int factor) {
        return new Complex(this.real * (double)factor, this.imaginary * (double)factor);
    }

    public Complex multiply(double factor) {
        return new Complex(this.real * factor, this.imaginary * factor);
    }

    public Complex negate() {
        return new Complex(-this.real, -this.imaginary);
    }

    public Complex subtract(Complex subtrahend) {
        return new Complex(this.real - subtrahend.real, this.imaginary - subtrahend.imaginary);
    }

    public Complex subtract(double subtrahend) {
        return new Complex(this.real - subtrahend, this.imaginary);
    }

    public Complex acos() {
        if (this.real == 0.0 && Double.isNaN(this.imaginary)) {
            return new Complex(1.5707963267948966, Double.NaN);
        }
        if (Complex.neitherInfiniteNorZeroNorNaN(this.real) && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(1.5707963267948966, Double.NEGATIVE_INFINITY);
        }
        if (this.real == Double.NEGATIVE_INFINITY && this.imaginary == 1.0) {
            return new Complex(Math.PI, Double.NEGATIVE_INFINITY);
        }
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == 1.0) {
            return new Complex(0.0, Double.NEGATIVE_INFINITY);
        }
        if (this.real == Double.NEGATIVE_INFINITY && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(2.356194490192345, Double.NEGATIVE_INFINITY);
        }
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(0.7853981633974483, Double.NEGATIVE_INFINITY);
        }
        if (this.real == Double.POSITIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return new Complex(Double.NaN, Double.POSITIVE_INFINITY);
        }
        if (this.real == Double.NEGATIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return new Complex(Double.NaN, Double.NEGATIVE_INFINITY);
        }
        if (Double.isNaN(this.real) && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(Double.NaN, Double.NEGATIVE_INFINITY);
        }
        return this.add(this.sqrt1z().multiply(I)).log().multiply(I.negate());
    }

    public Complex asin() {
        return this.sqrt1z().add(this.multiply(I)).log().multiply(I.negate());
    }

    public Complex atan() {
        return this.add(I).divide(I.subtract(this)).log().multiply(I.multiply(0.5));
    }

    public Complex asinh() {
        if (Complex.neitherInfiniteNorZeroNorNaN(this.real) && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(Double.POSITIVE_INFINITY, 1.5707963267948966);
        }
        if (this.real == Double.POSITIVE_INFINITY && !Double.isInfinite(this.imaginary) && !Double.isNaN(this.imaginary)) {
            return new Complex(Double.POSITIVE_INFINITY, 0.0);
        }
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(Double.POSITIVE_INFINITY, 0.7853981633974483);
        }
        if (this.real == Double.POSITIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
        }
        if (Double.isNaN(this.real) && this.imaginary == 0.0) {
            return new Complex(Double.NaN, 0.0);
        }
        if (Double.isNaN(this.real) && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
        }
        return this.square().add(ONE).sqrt().add(this).log();
    }

    public Complex atanh() {
        if (this.real == 0.0 && Double.isNaN(this.imaginary)) {
            return new Complex(0.0, Double.NaN);
        }
        if (Complex.neitherInfiniteNorZeroNorNaN(this.real) && this.imaginary == 0.0) {
            return new Complex(Double.POSITIVE_INFINITY, 0.0);
        }
        if (Complex.neitherInfiniteNorZeroNorNaN(this.real) && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(0.0, 1.5707963267948966);
        }
        if (this.real == Double.POSITIVE_INFINITY && Complex.neitherInfiniteNorZeroNorNaN(this.imaginary)) {
            return new Complex(0.0, 1.5707963267948966);
        }
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(0.0, 1.5707963267948966);
        }
        if (this.real == Double.POSITIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return new Complex(0.0, Double.NaN);
        }
        if (Double.isNaN(this.real) && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(0.0, 1.5707963267948966);
        }
        return this.add(ONE).divide(ONE.subtract(this)).log().multiply(0.5);
    }

    public Complex acosh() {
        return this.square().subtract(ONE).sqrt().add(this).log();
    }

    public Complex square() {
        return this.multiply(this);
    }

    public Complex cos() {
        return new Complex(Math.cos(this.real) * Math.cosh(this.imaginary), -Math.sin(this.real) * Math.sinh(this.imaginary));
    }

    public Complex cosh() {
        if (this.real == 0.0 && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(Double.NaN, 0.0);
        }
        if (this.real == 0.0 && Double.isNaN(this.imaginary)) {
            return new Complex(Double.NaN, 0.0);
        }
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == 0.0) {
            return new Complex(Double.POSITIVE_INFINITY, 0.0);
        }
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
        }
        if (this.real == Double.POSITIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
        }
        if (Double.isNaN(this.real) && this.imaginary == 0.0) {
            return new Complex(Double.NaN, 0.0);
        }
        return new Complex(Math.cosh(this.real) * Math.cos(this.imaginary), Math.sinh(this.real) * Math.sin(this.imaginary));
    }

    public Complex exp() {
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == 0.0) {
            return new Complex(Double.POSITIVE_INFINITY, 0.0);
        }
        if (this.real == Double.NEGATIVE_INFINITY && this.imaginary == Double.POSITIVE_INFINITY) {
            return ZERO;
        }
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
        }
        if (this.real == Double.NEGATIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return ZERO;
        }
        if (this.real == Double.POSITIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
        }
        if (Double.isNaN(this.real) && this.imaginary == 0.0) {
            return new Complex(Double.NaN, 0.0);
        }
        double expReal = Math.exp(this.real);
        return new Complex(expReal * Math.cos(this.imaginary), expReal * Math.sin(this.imaginary));
    }

    public Complex log() {
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(Double.POSITIVE_INFINITY, 0.7853981633974483);
        }
        if (this.real == Double.POSITIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
        }
        if (Double.isNaN(this.real) && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
        }
        return new Complex(Math.log(this.abs()), Math.atan2(this.imaginary, this.real));
    }

    public Complex log10() {
        return new Complex(Math.log(this.abs()) / Math.log(10.0), Math.atan2(this.imaginary, this.real));
    }

    public Complex pow(Complex x) {
        if (this.real == 0.0 && this.imaginary == 0.0) {
            if (x.real > 0.0 && x.imaginary == 0.0) {
                return ZERO;
            }
            return NAN;
        }
        return this.log().multiply(x).exp();
    }

    public Complex pow(double x) {
        if (this.real == 0.0 && this.imaginary == 0.0) {
            if (x > 0.0) {
                return ZERO;
            }
            return NAN;
        }
        return this.log().multiply(x).exp();
    }

    public Complex sin() {
        return new Complex(Math.sin(this.real) * Math.cosh(this.imaginary), Math.cos(this.real) * Math.sinh(this.imaginary));
    }

    public Complex sinh() {
        if (this.real == 0.0 && this.imaginary == 0.0) {
            return ZERO;
        }
        if (this.real == 0.0 && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(0.0, Double.NaN);
        }
        if (this.real == 0.0 && Double.isNaN(this.imaginary)) {
            return new Complex(0.0, Double.NaN);
        }
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == 0.0) {
            return new Complex(Double.POSITIVE_INFINITY, 0.0);
        }
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
        }
        if (this.real == Double.POSITIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
        }
        if (Double.isNaN(this.real) && this.imaginary == 0.0) {
            return new Complex(Double.NaN, 0.0);
        }
        return new Complex(Math.sinh(this.real) * Math.cos(this.imaginary), Math.cosh(this.real) * Math.sin(this.imaginary));
    }

    public Complex sqrt() {
        if (this.real == 0.0 && this.imaginary == 0.0) {
            return ZERO;
        }
        if (Complex.neitherInfiniteNorZeroNorNaN(this.real) && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        if (this.real == Double.NEGATIVE_INFINITY && Complex.neitherInfiniteNorZeroNorNaN(this.imaginary)) {
            return new Complex(0.0, Double.NaN);
        }
        if (this.real == Double.NEGATIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return new Complex(Double.NaN, Double.POSITIVE_INFINITY);
        }
        if (this.real == Double.POSITIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
        }
        double t = Math.sqrt((Math.abs(this.real) + this.abs()) / 2.0);
        if (this.real >= 0.0) {
            return new Complex(t, this.imaginary / (2.0 * t));
        }
        return new Complex(Math.abs(this.imaginary) / (2.0 * t), Math.copySign(1.0, this.imaginary) * t);
    }

    private Complex sqrt1z() {
        return ONE.subtract(this.square()).sqrt();
    }

    public Complex tan() {
        if (this.imaginary > 20.0) {
            return ONE;
        }
        if (this.imaginary < -20.0) {
            return new Complex(0.0, -1.0);
        }
        double real2 = 2.0 * this.real;
        double imaginary2 = 2.0 * this.imaginary;
        double d = Math.cos(real2) + Math.cosh(imaginary2);
        return new Complex(Math.sin(real2) / d, Math.sinh(imaginary2) / d);
    }

    public Complex tanh() {
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == Double.POSITIVE_INFINITY) {
            return ONE;
        }
        if (this.real == Double.POSITIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return ONE;
        }
        if (Double.isNaN(this.real) && this.imaginary == 0.0) {
            return new Complex(Double.NaN, 0.0);
        }
        double real2 = 2.0 * this.real;
        double imaginary2 = 2.0 * this.imaginary;
        double d = Math.cosh(real2) + Math.cos(imaginary2);
        return new Complex(Math.sinh(real2) / d, Math.sin(imaginary2) / d);
    }

    public double getArgument() {
        return Math.atan2(this.imaginary, this.real);
    }

    public double arg() {
        return this.getArgument();
    }

    public List<Complex> nthRoot(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("cannot compute zeroth root");
        }
        ArrayList<Complex> result = new ArrayList<Complex>();
        double nthRootOfAbs = Math.pow(this.abs(), 1.0 / (double)n);
        double nthPhi = this.getArgument() / (double)n;
        double slice = Math.PI * 2 / (double)n;
        double innerPart = nthPhi;
        for (int k = 0; k < Math.abs(n); ++k) {
            double realPart = nthRootOfAbs * Math.cos(innerPart);
            double imaginaryPart = nthRootOfAbs * Math.sin(innerPart);
            result.add(new Complex(realPart, imaginaryPart));
            innerPart += slice;
        }
        return result;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(FORMAT_START).append(this.real).append(FORMAT_SEP).append(this.imaginary).append(FORMAT_END);
        return s.toString();
    }

    private static void checkNotNegative(double arg) {
        if (arg <= 0.0) {
            throw new IllegalArgumentException("Complex: Non-positive argument");
        }
    }

    private static boolean equals(double x, double y) {
        return Double.doubleToLongBits(x) == Double.doubleToLongBits(y);
    }

    private static boolean neitherInfiniteNorZeroNorNaN(double d) {
        return !Double.isNaN(d) && !Double.isInfinite(d) && d != 0.0;
    }

    private static class ComplexParsingException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 20180430L;

        ComplexParsingException(String msg) {
            super(msg);
        }
    }
}

