/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.ContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.rng.UniformRandomProvider;

public class ConstantContinuousDistribution
extends AbstractContinuousDistribution {
    private final double value;

    public ConstantContinuousDistribution(double value) {
        this.value = value;
    }

    @Override
    public double density(double x) {
        return x == this.value ? 1.0 : 0.0;
    }

    @Override
    public double cumulativeProbability(double x) {
        return x < this.value ? 0.0 : 1.0;
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", p, 0, 1);
        }
        return this.value;
    }

    @Override
    public double getMean() {
        return this.value;
    }

    @Override
    public double getVariance() {
        return 0.0;
    }

    @Override
    public double getSupportLowerBound() {
        return this.value;
    }

    @Override
    public double getSupportUpperBound() {
        return this.value;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return new ContinuousDistribution.Sampler(){

            @Override
            public double sample() {
                return ConstantContinuousDistribution.this.value;
            }
        };
    }
}

