/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractDiscreteDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DiscreteDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.RejectionInversionZipfSampler;

public class ZipfDistribution
extends AbstractDiscreteDistribution {
    private final int numberOfElements;
    private final double exponent;
    private final double nthHarmonic;

    public ZipfDistribution(int numberOfElements, double exponent) {
        if (numberOfElements <= 0) {
            throw new DistributionException("Number {0} is negative", numberOfElements);
        }
        if (exponent <= 0.0) {
            throw new DistributionException("Number {0} is negative", exponent);
        }
        this.numberOfElements = numberOfElements;
        this.exponent = exponent;
        this.nthHarmonic = this.generalizedHarmonic(numberOfElements, exponent);
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public double getExponent() {
        return this.exponent;
    }

    @Override
    public double probability(int x) {
        if (x <= 0 || x > this.numberOfElements) {
            return 0.0;
        }
        return 1.0 / Math.pow(x, this.exponent) / this.nthHarmonic;
    }

    @Override
    public double logProbability(int x) {
        if (x <= 0 || x > this.numberOfElements) {
            return Double.NEGATIVE_INFINITY;
        }
        return -Math.log(x) * this.exponent - Math.log(this.nthHarmonic);
    }

    @Override
    public double cumulativeProbability(int x) {
        if (x <= 0) {
            return 0.0;
        }
        if (x >= this.numberOfElements) {
            return 1.0;
        }
        return this.generalizedHarmonic(x, this.exponent) / this.nthHarmonic;
    }

    @Override
    public double getMean() {
        int N = this.getNumberOfElements();
        double s = this.getExponent();
        double Hs1 = this.generalizedHarmonic(N, s - 1.0);
        double Hs = this.nthHarmonic;
        return Hs1 / Hs;
    }

    @Override
    public double getVariance() {
        int N = this.getNumberOfElements();
        double s = this.getExponent();
        double Hs2 = this.generalizedHarmonic(N, s - 2.0);
        double Hs1 = this.generalizedHarmonic(N, s - 1.0);
        double Hs = this.nthHarmonic;
        return Hs2 / Hs - Hs1 * Hs1 / (Hs * Hs);
    }

    private double generalizedHarmonic(int n, double m) {
        double value = 0.0;
        for (int k = n; k > 0; --k) {
            value += 1.0 / Math.pow(k, m);
        }
        return value;
    }

    @Override
    public int getSupportLowerBound() {
        return 1;
    }

    @Override
    public int getSupportUpperBound() {
        return this.getNumberOfElements();
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public DiscreteDistribution.Sampler createSampler(final UniformRandomProvider rng) {
        return new DiscreteDistribution.Sampler(){
            private final DiscreteSampler sampler;
            {
                this.sampler = new RejectionInversionZipfSampler(rng, ZipfDistribution.this.numberOfElements, ZipfDistribution.this.exponent);
            }

            @Override
            public int sample() {
                return this.sampler.sample();
            }
        };
    }
}

