/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import java.util.Arrays;
import org.apache.commons.rng.core.source64.LongProvider;
import org.apache.commons.rng.core.util.NumberFactory;

public class XorShift1024Star
extends LongProvider {
    private static final int SEED_SIZE = 16;
    private final long[] state = new long[16];
    private final long multiplier;
    private int index;

    public XorShift1024Star(long[] seed) {
        this(seed, 1181783497276652981L);
    }

    protected XorShift1024Star(long[] seed, long multiplier) {
        this.setSeedInternal(seed);
        this.multiplier = multiplier;
    }

    @Override
    protected byte[] getStateInternal() {
        long[] s = Arrays.copyOf(this.state, 17);
        s[16] = this.index;
        return this.composeStateInternal(NumberFactory.makeByteArray(s), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 136);
        long[] tmp = NumberFactory.makeLongArray(c[0]);
        System.arraycopy(tmp, 0, this.state, 0, 16);
        this.index = (int)tmp[16];
        super.setStateInternal(c[1]);
    }

    private void setSeedInternal(long[] seed) {
        this.fillState(this.state, seed);
        this.index = 0;
    }

    @Override
    public long next() {
        long s0 = this.state[this.index];
        this.index = this.index + 1 & 0xF;
        long s1 = this.state[this.index];
        s1 ^= s1 << 31;
        this.state[this.index] = s1 ^ s0 ^ s1 >>> 11 ^ s0 >>> 30;
        return this.state[this.index] * this.multiplier;
    }
}

