/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.AhrensDieterExponentialSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.SmallMeanPoissonSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratNormalizedGaussianSampler;

public class LargeMeanPoissonSampler
implements DiscreteSampler {
    private static final double MAX_MEAN = 1.0737418235E9;
    private static final InternalUtils.FactorialLog NO_CACHE_FACTORIAL_LOG;
    private static final DiscreteSampler NO_SMALL_MEAN_POISSON_SAMPLER;
    private final UniformRandomProvider rng;
    private final ContinuousSampler exponential;
    private final ContinuousSampler gaussian;
    private final InternalUtils.FactorialLog factorialLog;
    private final double lambda;
    private final double logLambda;
    private final double logLambdaFactorial;
    private final double delta;
    private final double halfDelta;
    private final double twolpd;
    private final double p1;
    private final double p2;
    private final double c1;
    private final DiscreteSampler smallMeanPoissonSampler;

    public LargeMeanPoissonSampler(UniformRandomProvider rng, double mean) {
        if (mean < 1.0) {
            throw new IllegalArgumentException("mean is not >= 1: " + mean);
        }
        if (mean > 1.0737418235E9) {
            throw new IllegalArgumentException("mean " + mean + " > 1.0737418235E9");
        }
        this.rng = rng;
        this.gaussian = new ZigguratNormalizedGaussianSampler(rng);
        this.exponential = new AhrensDieterExponentialSampler(rng, 1.0);
        this.factorialLog = NO_CACHE_FACTORIAL_LOG;
        this.lambda = Math.floor(mean);
        this.logLambda = Math.log(this.lambda);
        this.logLambdaFactorial = this.factorialLog((int)this.lambda);
        this.delta = Math.sqrt(this.lambda * Math.log(32.0 * this.lambda / Math.PI + 1.0));
        this.halfDelta = this.delta / 2.0;
        this.twolpd = 2.0 * this.lambda + this.delta;
        this.c1 = 1.0 / (8.0 * this.lambda);
        double a1 = Math.sqrt(Math.PI * this.twolpd) * Math.exp(this.c1);
        double a2 = this.twolpd / this.delta * Math.exp(-this.delta * (1.0 + this.delta) / this.twolpd);
        double aSum = a1 + a2 + 1.0;
        this.p1 = a1 / aSum;
        this.p2 = a2 / aSum;
        double lambdaFractional = mean - this.lambda;
        this.smallMeanPoissonSampler = lambdaFractional < Double.MIN_VALUE ? NO_SMALL_MEAN_POISSON_SAMPLER : new SmallMeanPoissonSampler(rng, lambdaFractional);
    }

    LargeMeanPoissonSampler(UniformRandomProvider rng, LargeMeanPoissonSamplerState state, double lambdaFractional) {
        if (lambdaFractional < 0.0 || lambdaFractional >= 1.0) {
            throw new IllegalArgumentException("lambdaFractional must be in the range 0 (inclusive) to 1 (exclusive): " + lambdaFractional);
        }
        this.rng = rng;
        this.gaussian = new ZigguratNormalizedGaussianSampler(rng);
        this.exponential = new AhrensDieterExponentialSampler(rng, 1.0);
        this.factorialLog = NO_CACHE_FACTORIAL_LOG;
        this.lambda = state.getLambdaRaw();
        this.logLambda = state.getLogLambda();
        this.logLambdaFactorial = state.getLogLambdaFactorial();
        this.delta = state.getDelta();
        this.halfDelta = state.getHalfDelta();
        this.twolpd = state.getTwolpd();
        this.p1 = state.getP1();
        this.p2 = state.getP2();
        this.c1 = state.getC1();
        this.smallMeanPoissonSampler = lambdaFractional < Double.MIN_VALUE ? NO_SMALL_MEAN_POISSON_SAMPLER : new SmallMeanPoissonSampler(rng, lambdaFractional);
    }

    @Override
    public int sample() {
        double y;
        int y2;
        block6: {
            int n = y2 = this.smallMeanPoissonSampler == null ? 0 : this.smallMeanPoissonSampler.sample();
            while (true) {
                double v;
                double x;
                double u;
                if ((u = this.rng.nextDouble()) <= this.p1) {
                    double n2 = this.gaussian.sample();
                    x = n2 * Math.sqrt(this.lambda + this.halfDelta) - 0.5;
                    if (x > this.delta || x < -this.lambda) continue;
                    y = x < 0.0 ? Math.floor(x) : Math.ceil(x);
                    double e = this.exponential.sample();
                    v = -e - 0.5 * n2 * n2 + this.c1;
                } else {
                    if (u > this.p1 + this.p2) {
                        y = this.lambda;
                        break block6;
                    }
                    x = this.delta + this.twolpd / this.delta * this.exponential.sample();
                    y = Math.ceil(x);
                    v = -this.exponential.sample() - this.delta * (x + 1.0) / this.twolpd;
                }
                boolean a = x < 0.0;
                double t = y * (y + 1.0) / (2.0 * this.lambda);
                if (v < -t && !a) {
                    y = this.lambda + y;
                    break block6;
                }
                double qr = t * ((2.0 * y + 1.0) / (6.0 * this.lambda) - 1.0);
                double qa = qr - t * t / (3.0 * (this.lambda + (double)a * (y + 1.0)));
                if (v < qa) {
                    y = this.lambda + y;
                    break block6;
                }
                if (!(v > qr) && v < y * this.logLambda - this.factorialLog((int)(y + this.lambda)) + this.logLambdaFactorial) break;
            }
            y = this.lambda + y;
        }
        return (int)Math.min((long)y2 + (long)y, Integer.MAX_VALUE);
    }

    private double factorialLog(int n) {
        return this.factorialLog.value(n);
    }

    public String toString() {
        return "Large Mean Poisson deviate [" + this.rng.toString() + "]";
    }

    LargeMeanPoissonSamplerState getState() {
        return new LargeMeanPoissonSamplerState(this.lambda, this.logLambda, this.logLambdaFactorial, this.delta, this.halfDelta, this.twolpd, this.p1, this.p2, this.c1);
    }

    static {
        NO_SMALL_MEAN_POISSON_SAMPLER = null;
        NO_CACHE_FACTORIAL_LOG = InternalUtils.FactorialLog.create();
    }

    static final class LargeMeanPoissonSamplerState {
        private final double lambda;
        private final double logLambda;
        private final double logLambdaFactorial;
        private final double delta;
        private final double halfDelta;
        private final double twolpd;
        private final double p1;
        private final double p2;
        private final double c1;

        private LargeMeanPoissonSamplerState(double lambda, double logLambda, double logLambdaFactorial, double delta, double halfDelta, double twolpd, double p1, double p2, double c1) {
            this.lambda = lambda;
            this.logLambda = logLambda;
            this.logLambdaFactorial = logLambdaFactorial;
            this.delta = delta;
            this.halfDelta = halfDelta;
            this.twolpd = twolpd;
            this.p1 = p1;
            this.p2 = p2;
            this.c1 = c1;
        }

        int getLambda() {
            return (int)this.getLambdaRaw();
        }

        double getLambdaRaw() {
            return this.lambda;
        }

        double getLogLambda() {
            return this.logLambda;
        }

        double getLogLambdaFactorial() {
            return this.logLambdaFactorial;
        }

        double getDelta() {
            return this.delta;
        }

        double getHalfDelta() {
            return this.halfDelta;
        }

        double getTwolpd() {
            return this.twolpd;
        }

        double getP1() {
            return this.p1;
        }

        double getP2() {
            return this.p2;
        }

        double getC1() {
            return this.c1;
        }
    }
}

