/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.simple.internal;

import java.security.SecureRandom;
import org.apache.commons.rng.core.source32.RandomIntSource;
import org.apache.commons.rng.core.source32.Well44497b;
import org.apache.commons.rng.core.source64.RandomLongSource;
import org.apache.commons.rng.core.source64.SplitMix64;
import org.apache.commons.rng.core.util.NumberFactory;

public final class SeedFactory {
    private static final RandomIntSource SEED_GENERATOR;

    private SeedFactory() {
    }

    public static int createInt() {
        return SeedFactory.createInt(SEED_GENERATOR, System.identityHashCode(new Object()));
    }

    public static long createLong() {
        return SeedFactory.createLong(SEED_GENERATOR, System.identityHashCode(new Object()));
    }

    public static int[] createIntArray(int n) {
        return SeedFactory.createIntArray(n, SEED_GENERATOR, new Object());
    }

    public static long[] createLongArray(int n) {
        return SeedFactory.createLongArray(n, SEED_GENERATOR, new Object());
    }

    static long[] createLongArray(int n, RandomIntSource source) {
        return SeedFactory.createLongArray(n, source, null);
    }

    static int[] createIntArray(int n, RandomLongSource source) {
        return SeedFactory.createIntArray(n, source, null);
    }

    static int[] createIntArray(int n, RandomIntSource source) {
        return SeedFactory.createIntArray(n, source, null);
    }

    private static long[] createLongArray(int n, RandomIntSource source, Object h) {
        long[] array = new long[n];
        int hash = System.identityHashCode(h);
        for (int i = 0; i < n; ++i) {
            array[i] = SeedFactory.createLong(source, hash);
        }
        return array;
    }

    private static int[] createIntArray(int n, RandomLongSource source, Object h) {
        int[] array = new int[n];
        int hash = System.identityHashCode(h);
        for (int i = 0; i < n; i += 2) {
            long v = SeedFactory.createLong(source, hash);
            array[i] = NumberFactory.extractHi(v);
            if (i + 1 >= n) continue;
            array[i + 1] = NumberFactory.extractLo(v);
        }
        return array;
    }

    private static int[] createIntArray(int n, RandomIntSource source, Object h) {
        int[] array = new int[n];
        int hash = System.identityHashCode(h);
        for (int i = 0; i < n; ++i) {
            array[i] = SeedFactory.createInt(source, hash);
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long createLong(RandomLongSource source, int number) {
        RandomLongSource randomLongSource = source;
        synchronized (randomLongSource) {
            return source.next() ^ NumberFactory.makeLong(number, number);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long createLong(RandomIntSource source, int number) {
        RandomIntSource randomIntSource = source;
        synchronized (randomIntSource) {
            return NumberFactory.makeLong(source.next() ^ number, source.next() ^ number);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int createInt(RandomIntSource source, int number) {
        RandomIntSource randomIntSource = source;
        synchronized (randomIntSource) {
            return source.next() ^ number;
        }
    }

    static {
        SecureRandom seedGen = new SecureRandom();
        long initSeed = NumberFactory.makeLong(seedGen.generateSeed(8));
        SplitMix64 rng = new SplitMix64(initSeed);
        int blockCount = 1391;
        SEED_GENERATOR = new Well44497b(SeedFactory.createIntArray(1391, rng));
    }
}

