/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.geometry.euclidean.twod;

import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.geometry.Point;
import org.apache.commons.math4.geometry.Vector;
import org.apache.commons.math4.geometry.euclidean.oned.Cartesian1D;
import org.apache.commons.math4.geometry.euclidean.oned.Euclidean1D;
import org.apache.commons.math4.geometry.euclidean.oned.IntervalsSet;
import org.apache.commons.math4.geometry.euclidean.oned.OrientedPoint;
import org.apache.commons.math4.geometry.euclidean.twod.Cartesian2D;
import org.apache.commons.math4.geometry.euclidean.twod.Euclidean2D;
import org.apache.commons.math4.geometry.euclidean.twod.PolygonsSet;
import org.apache.commons.math4.geometry.euclidean.twod.SubLine;
import org.apache.commons.math4.geometry.partitioning.Embedding;
import org.apache.commons.math4.geometry.partitioning.Hyperplane;
import org.apache.commons.math4.geometry.partitioning.SubHyperplane;
import org.apache.commons.math4.geometry.partitioning.Transform;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.numbers.angle.PlaneAngleRadians;
import org.apache.commons.numbers.arrays.LinearCombination;

public class Line
implements Hyperplane<Euclidean2D>,
Embedding<Euclidean2D, Euclidean1D> {
    private double angle;
    private double cos;
    private double sin;
    private double originOffset;
    private final double tolerance;
    private Line reverse;

    public Line(Cartesian2D p1, Cartesian2D p2, double tolerance) {
        this.reset(p1, p2);
        this.tolerance = tolerance;
    }

    public Line(Cartesian2D p, double angle, double tolerance) {
        this.reset(p, angle);
        this.tolerance = tolerance;
    }

    private Line(double angle, double cos, double sin, double originOffset, double tolerance) {
        this.angle = angle;
        this.cos = cos;
        this.sin = sin;
        this.originOffset = originOffset;
        this.tolerance = tolerance;
        this.reverse = null;
    }

    public Line(Line line) {
        this.angle = PlaneAngleRadians.normalizeBetweenZeroAndTwoPi(line.angle);
        this.cos = line.cos;
        this.sin = line.sin;
        this.originOffset = line.originOffset;
        this.tolerance = line.tolerance;
        this.reverse = null;
    }

    public Line copySelf() {
        return new Line(this);
    }

    public void reset(Cartesian2D p1, Cartesian2D p2) {
        this.unlinkReverse();
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        double d = FastMath.hypot(dx, dy);
        if (d == 0.0) {
            this.angle = 0.0;
            this.cos = 1.0;
            this.sin = 0.0;
            this.originOffset = p1.getY();
        } else {
            this.angle = Math.PI + FastMath.atan2(-dy, -dx);
            this.cos = dx / d;
            this.sin = dy / d;
            this.originOffset = LinearCombination.value(p2.getX(), p1.getY(), -p1.getX(), p2.getY()) / d;
        }
    }

    public void reset(Cartesian2D p, double alpha) {
        this.unlinkReverse();
        this.angle = PlaneAngleRadians.normalizeBetweenZeroAndTwoPi(alpha);
        this.cos = FastMath.cos(this.angle);
        this.sin = FastMath.sin(this.angle);
        this.originOffset = LinearCombination.value(this.cos, p.getY(), -this.sin, p.getX());
    }

    public void revertSelf() {
        this.unlinkReverse();
        this.angle = this.angle < Math.PI ? (this.angle += Math.PI) : (this.angle -= Math.PI);
        this.cos = -this.cos;
        this.sin = -this.sin;
        this.originOffset = -this.originOffset;
    }

    private void unlinkReverse() {
        if (this.reverse != null) {
            this.reverse.reverse = null;
        }
        this.reverse = null;
    }

    public Line getReverse() {
        if (this.reverse == null) {
            this.reverse = new Line(this.angle < Math.PI ? this.angle + Math.PI : this.angle - Math.PI, -this.cos, -this.sin, -this.originOffset, this.tolerance);
            this.reverse.reverse = this;
        }
        return this.reverse;
    }

    public Cartesian1D toSubSpace(Vector<Euclidean2D> vector) {
        return this.toSubSpace((Cartesian2D)vector);
    }

    public Cartesian2D toSpace(Vector<Euclidean1D> vector) {
        return this.toSpace((Cartesian1D)vector);
    }

    public Cartesian1D toSubSpace(Point<Euclidean2D> point) {
        return this.toSubSpace((Cartesian2D)point);
    }

    public Cartesian2D toSpace(Point<Euclidean1D> point) {
        return this.toSpace((Cartesian1D)point);
    }

    public Cartesian1D toSubSpace(Cartesian2D cartesian) {
        return new Cartesian1D(LinearCombination.value(this.cos, cartesian.getX(), this.sin, cartesian.getY()));
    }

    public Cartesian2D toSpace(Cartesian1D cartesian) {
        double abscissa = cartesian.getX();
        return new Cartesian2D(LinearCombination.value(abscissa, this.cos, -this.originOffset, this.sin), LinearCombination.value(abscissa, this.sin, this.originOffset, this.cos));
    }

    public Cartesian2D intersection(Line other) {
        double d = LinearCombination.value(this.sin, other.cos, -other.sin, this.cos);
        if (FastMath.abs(d) < this.tolerance) {
            return null;
        }
        return new Cartesian2D(LinearCombination.value(this.cos, other.originOffset, -other.cos, this.originOffset) / d, LinearCombination.value(this.sin, other.originOffset, -other.sin, this.originOffset) / d);
    }

    @Override
    public Point<Euclidean2D> project(Point<Euclidean2D> point) {
        return this.toSpace((Cartesian1D)this.toSubSpace((Point)point));
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    public SubLine wholeHyperplane() {
        return new SubLine(this, new IntervalsSet(this.tolerance));
    }

    public PolygonsSet wholeSpace() {
        return new PolygonsSet(this.tolerance);
    }

    public double getOffset(Line line) {
        return this.originOffset + (LinearCombination.value(this.cos, line.cos, this.sin, line.sin) > 0.0 ? -line.originOffset : line.originOffset);
    }

    @Override
    public double getOffset(Vector<Euclidean2D> vector) {
        return this.getOffset((Cartesian2D)vector);
    }

    @Override
    public double getOffset(Point<Euclidean2D> point) {
        return this.getOffset((Cartesian2D)point);
    }

    public double getOffset(Cartesian2D cartesian) {
        return LinearCombination.value(this.sin, cartesian.getX(), -this.cos, cartesian.getY(), 1.0, this.originOffset);
    }

    @Override
    public boolean sameOrientationAs(Hyperplane<Euclidean2D> other) {
        Line otherL = (Line)other;
        return LinearCombination.value(this.sin, otherL.sin, this.cos, otherL.cos) >= 0.0;
    }

    public Cartesian2D getPointAt(Cartesian1D abscissa, double offset) {
        double x = abscissa.getX();
        double dOffset = offset - this.originOffset;
        return new Cartesian2D(LinearCombination.value(x, this.cos, dOffset, this.sin), LinearCombination.value(x, this.sin, -dOffset, this.cos));
    }

    public boolean contains(Cartesian2D p) {
        return FastMath.abs(this.getOffset(p)) < this.tolerance;
    }

    public double distance(Cartesian2D p) {
        return FastMath.abs(this.getOffset(p));
    }

    public boolean isParallelTo(Line line) {
        return FastMath.abs(LinearCombination.value(this.sin, line.cos, -this.cos, line.sin)) < this.tolerance;
    }

    public void translateToPoint(Cartesian2D p) {
        this.originOffset = LinearCombination.value(this.cos, p.getY(), -this.sin, p.getX());
    }

    public double getAngle() {
        return PlaneAngleRadians.normalizeBetweenZeroAndTwoPi(this.angle);
    }

    public void setAngle(double angle) {
        this.unlinkReverse();
        this.angle = PlaneAngleRadians.normalizeBetweenZeroAndTwoPi(angle);
        this.cos = FastMath.cos(this.angle);
        this.sin = FastMath.sin(this.angle);
    }

    public double getOriginOffset() {
        return this.originOffset;
    }

    public void setOriginOffset(double offset) {
        this.unlinkReverse();
        this.originOffset = offset;
    }

    public static Transform<Euclidean2D, Euclidean1D> getTransform(double cXX, double cYX, double cXY, double cYY, double cX1, double cY1) throws MathIllegalArgumentException {
        return new LineTransform(cXX, cYX, cXY, cYY, cX1, cY1);
    }

    private static class LineTransform
    implements Transform<Euclidean2D, Euclidean1D> {
        private final double cXX;
        private final double cYX;
        private final double cXY;
        private final double cYY;
        private final double cX1;
        private final double cY1;
        private final double c1Y;
        private final double c1X;
        private final double c11;

        LineTransform(double cXX, double cYX, double cXY, double cYY, double cX1, double cY1) throws MathIllegalArgumentException {
            this.cXX = cXX;
            this.cYX = cYX;
            this.cXY = cXY;
            this.cYY = cYY;
            this.cX1 = cX1;
            this.cY1 = cY1;
            this.c1Y = LinearCombination.value(cXY, cY1, -cYY, cX1);
            this.c1X = LinearCombination.value(cXX, cY1, -cYX, cX1);
            this.c11 = LinearCombination.value(cXX, cYY, -cYX, cXY);
            if (FastMath.abs(this.c11) < 1.0E-20) {
                throw new MathIllegalArgumentException(LocalizedFormats.NON_INVERTIBLE_TRANSFORM, new Object[0]);
            }
        }

        public Cartesian2D apply(Point<Euclidean2D> point) {
            Cartesian2D p2D = (Cartesian2D)point;
            double x = p2D.getX();
            double y = p2D.getY();
            return new Cartesian2D(LinearCombination.value(this.cXX, x, this.cXY, y, this.cX1, 1.0), LinearCombination.value(this.cYX, x, this.cYY, y, this.cY1, 1.0));
        }

        public Line apply(Hyperplane<Euclidean2D> hyperplane) {
            Line line = (Line)hyperplane;
            double rOffset = LinearCombination.value(this.c1X, line.cos, this.c1Y, line.sin, this.c11, line.originOffset);
            double rCos = LinearCombination.value(this.cXX, line.cos, this.cXY, line.sin);
            double rSin = LinearCombination.value(this.cYX, line.cos, this.cYY, line.sin);
            double inv = 1.0 / FastMath.sqrt(rSin * rSin + rCos * rCos);
            return new Line(Math.PI + FastMath.atan2(-rSin, -rCos), inv * rCos, inv * rSin, inv * rOffset, line.tolerance);
        }

        @Override
        public SubHyperplane<Euclidean1D> apply(SubHyperplane<Euclidean1D> sub, Hyperplane<Euclidean2D> original, Hyperplane<Euclidean2D> transformed) {
            OrientedPoint op = (OrientedPoint)sub.getHyperplane();
            Line originalLine = (Line)original;
            Line transformedLine = (Line)transformed;
            Cartesian1D newLoc = transformedLine.toSubSpace((Cartesian2D)this.apply((Point)originalLine.toSpace(op.getLocation())));
            return new OrientedPoint(newLoc, op.isDirect(), originalLine.tolerance).wholeHyperplane();
        }
    }
}

