/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.ml.neuralnet;

import io.virtdata.shaded.oac.statistics.distribution.ContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.UniformContinuousDistribution;
import org.apache.commons.math4.analysis.UnivariateFunction;
import org.apache.commons.math4.analysis.function.Constant;
import org.apache.commons.math4.ml.neuralnet.FeatureInitializer;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.simple.RandomSource;

public class FeatureInitializerFactory {
    private FeatureInitializerFactory() {
    }

    public static FeatureInitializer uniform(UniformRandomProvider rng, double min, double max) {
        return FeatureInitializerFactory.randomize(new UniformContinuousDistribution(min, max).createSampler(rng), FeatureInitializerFactory.function(new Constant(0.0), 0.0, 0.0));
    }

    public static FeatureInitializer uniform(double min, double max) {
        return FeatureInitializerFactory.uniform(RandomSource.create(RandomSource.WELL_19937_C), min, max);
    }

    public static FeatureInitializer function(final UnivariateFunction f, final double init, final double inc) {
        return new FeatureInitializer(){
            private double arg;
            {
                this.arg = init;
            }

            @Override
            public double value() {
                double result = f.value(this.arg);
                this.arg += inc;
                return result;
            }
        };
    }

    public static FeatureInitializer randomize(final ContinuousDistribution.Sampler random, final FeatureInitializer orig) {
        return new FeatureInitializer(){

            @Override
            public double value() {
                return orig.value() + random.sample();
            }
        };
    }
}

