/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.continuous.int_double;

import io.virtdata.continuous.common.InterpolatingIntDoubleSampler;
import io.virtdata.continuous.common.RealDistributionICDSource;
import io.virtdata.continuous.common.RealIntDoubleSampler;
import io.virtdata.shaded.oac.statistics.distribution.ContinuousDistribution;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.IntToDoubleFunction;

public class IntToDoubleContinuousCurve
implements IntToDoubleFunction {
    private ContinuousDistribution distribution;
    private IntToDoubleFunction function;
    public static final String COMPUTE = "compute";
    public static final String INTERPOLATE = "interpolate";
    public static final String MAP = "map";
    public static final String HASH = "hash";
    public static final String CLAMP = "clamp";
    public static final String NOCLAMP = "noclamp";
    private static final HashSet<String> validModifiers = new HashSet<String>(){
        {
            this.add(IntToDoubleContinuousCurve.COMPUTE);
            this.add(IntToDoubleContinuousCurve.INTERPOLATE);
            this.add(IntToDoubleContinuousCurve.MAP);
            this.add(IntToDoubleContinuousCurve.HASH);
            this.add(IntToDoubleContinuousCurve.CLAMP);
            this.add(IntToDoubleContinuousCurve.NOCLAMP);
        }
    };

    public IntToDoubleContinuousCurve(ContinuousDistribution distribution, String ... modslist) {
        this.distribution = distribution;
        HashSet<String> mods = new HashSet<String>(Arrays.asList(modslist));
        RealDistributionICDSource icdSource = new RealDistributionICDSource(distribution);
        if (mods.contains(HASH) && mods.contains(MAP)) {
            throw new RuntimeException("mods must not contain both hash and map.");
        }
        if (mods.contains(INTERPOLATE) && mods.contains(COMPUTE)) {
            throw new RuntimeException("mods must not contain both interpolate and compute.");
        }
        if (mods.contains(CLAMP) && mods.contains(NOCLAMP)) {
            throw new RuntimeException("mods must not contain both clamp and noclamp.");
        }
        for (String s : modslist) {
            if (validModifiers.contains(s)) continue;
            throw new RuntimeException("modifier '" + s + "' is not a valid modifier. Use one of " + validModifiers.toString() + " instead.");
        }
        boolean hash = mods.contains(HASH) || !mods.contains(MAP);
        boolean interpolate = mods.contains(INTERPOLATE) || !mods.contains(COMPUTE);
        boolean clamp = mods.contains(CLAMP) || !mods.contains(NOCLAMP);
        this.function = interpolate ? new InterpolatingIntDoubleSampler(icdSource, 1000, hash, clamp, 9.223372036854776E18) : new RealIntDoubleSampler(icdSource, hash, clamp, 9.223372036854776E18);
    }

    @Override
    public double applyAsDouble(int value) {
        return this.function.applyAsDouble(value);
    }
}

