/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.discrete.common;

import java.nio.ByteBuffer;
import java.util.function.LongUnaryOperator;
import org.greenrobot.essentials.hash.Murmur3F;

public class ThreadSafeHash
implements LongUnaryOperator {
    private static ThreadLocal<HashState> tlstate = ThreadLocal.withInitial(HashState::new);

    @Override
    public long applyAsLong(long value) {
        HashState state = tlstate.get();
        state.murmur3F.reset();
        state.byteBuffer.putLong(0, value);
        state.murmur3F.update(state.byteBuffer.array(), 0, 8);
        long result = Math.abs(state.murmur3F.getValue());
        return result;
    }

    private static class HashState {
        public Murmur3F murmur3F = new Murmur3F();
        public ByteBuffer byteBuffer = ByteBuffer.allocate(8);
    }
}

