/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.discrete.common;

import io.virtdata.discrete.common.ThreadSafeHash;
import java.util.function.DoubleToIntFunction;
import java.util.function.LongToIntFunction;

public class DiscreteLongIntSampler
implements LongToIntFunction {
    private final DoubleToIntFunction f;
    private ThreadSafeHash hash;

    public DiscreteLongIntSampler(DoubleToIntFunction parentFunc, boolean hash) {
        this.f = parentFunc;
        if (hash) {
            this.hash = new ThreadSafeHash();
        }
    }

    @Override
    public int applyAsInt(long value) {
        if (this.hash != null) {
            value = this.hash.applyAsLong(value);
        }
        double unit = (double)value / 9.223372036854776E18;
        int sample = this.f.applyAsInt(unit);
        return sample;
    }
}

