/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.discrete.common;

import io.virtdata.discrete.common.ThreadSafeHash;
import java.util.function.DoubleToIntFunction;
import java.util.function.IntUnaryOperator;

public class InterpolatingIntIntSampler
implements IntUnaryOperator {
    private final double[] lut;
    private final DoubleToIntFunction f;
    private int resolution;
    private ThreadSafeHash hash;

    public InterpolatingIntIntSampler(DoubleToIntFunction icdSource, int resolution, boolean hash) {
        this.f = icdSource;
        this.resolution = resolution;
        if (hash) {
            this.hash = new ThreadSafeHash();
        }
        this.lut = this.precompute();
    }

    private double[] precompute() {
        double[] precomputed = new double[this.resolution + 2];
        for (int s = 0; s <= this.resolution; ++s) {
            double rangedToUnit = (double)s / (double)this.resolution;
            int sampleValue = this.f.applyAsInt(rangedToUnit);
            precomputed[s] = sampleValue;
        }
        precomputed[precomputed.length - 1] = 0.0;
        return precomputed;
    }

    @Override
    public int applyAsInt(int input) {
        int value = input;
        if (this.hash != null) {
            value = (int)(this.hash.applyAsLong(input) % Integer.MAX_VALUE);
        }
        double unit = (double)value / 2.147483647E9;
        double samplePoint = unit * (double)this.resolution;
        int leftidx = (int)samplePoint;
        double leftPartial = samplePoint - (double)leftidx;
        double leftComponent = this.lut[leftidx] * (1.0 - leftPartial);
        double rightComponent = this.lut[leftidx + 1] * leftPartial;
        double sample = leftComponent + rightComponent;
        return (int)sample;
    }
}

