/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.geometry.euclidean.threed;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.geometry.Point;
import org.apache.commons.math4.geometry.euclidean.oned.Cartesian1D;
import org.apache.commons.math4.geometry.euclidean.oned.Interval;
import org.apache.commons.math4.geometry.euclidean.oned.IntervalsSet;
import org.apache.commons.math4.geometry.euclidean.threed.Cartesian3D;
import org.apache.commons.math4.geometry.euclidean.threed.Line;
import org.apache.commons.math4.geometry.euclidean.threed.Segment;
import org.apache.commons.math4.geometry.partitioning.Region;

public class SubLine {
    private final Line line;
    private final IntervalsSet remainingRegion;

    public SubLine(Line line, IntervalsSet remainingRegion) {
        this.line = line;
        this.remainingRegion = remainingRegion;
    }

    public SubLine(Cartesian3D start, Cartesian3D end, double tolerance) throws MathIllegalArgumentException {
        this(new Line(start, end, tolerance), SubLine.buildIntervalSet(start, end, tolerance));
    }

    public SubLine(Segment segment) throws MathIllegalArgumentException {
        this(segment.getLine(), SubLine.buildIntervalSet(segment.getStart(), segment.getEnd(), segment.getLine().getTolerance()));
    }

    public List<Segment> getSegments() {
        List<Interval> list = this.remainingRegion.asList();
        ArrayList<Segment> segments = new ArrayList<Segment>(list.size());
        for (Interval interval : list) {
            Cartesian3D start = this.line.toSpace(new Cartesian1D(interval.getInf()));
            Cartesian3D end = this.line.toSpace(new Cartesian1D(interval.getSup()));
            segments.add(new Segment(start, end, this.line));
        }
        return segments;
    }

    public Cartesian3D intersection(SubLine subLine, boolean includeEndPoints) {
        Cartesian3D v1D = this.line.intersection(subLine.line);
        if (v1D == null) {
            return null;
        }
        Region.Location loc1 = this.remainingRegion.checkPoint(this.line.toSubSpace((Point)v1D));
        Region.Location loc2 = subLine.remainingRegion.checkPoint(subLine.line.toSubSpace((Point)v1D));
        if (includeEndPoints) {
            return loc1 != Region.Location.OUTSIDE && loc2 != Region.Location.OUTSIDE ? v1D : null;
        }
        return loc1 == Region.Location.INSIDE && loc2 == Region.Location.INSIDE ? v1D : null;
    }

    private static IntervalsSet buildIntervalSet(Cartesian3D start, Cartesian3D end, double tolerance) throws MathIllegalArgumentException {
        Line line = new Line(start, end, tolerance);
        return new IntervalsSet(((Cartesian1D)line.toSubSpace((Point)start)).getX(), ((Cartesian1D)line.toSubSpace((Point)end)).getX(), tolerance);
    }
}

