/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.geometry.euclidean.twod;

import org.apache.commons.math4.geometry.Point;
import org.apache.commons.math4.geometry.euclidean.twod.Cartesian2D;
import org.apache.commons.math4.geometry.euclidean.twod.Euclidean2D;
import org.apache.commons.math4.geometry.euclidean.twod.Line;
import org.apache.commons.math4.util.FastMath;

public class Segment {
    private final Cartesian2D start;
    private final Cartesian2D end;
    private final Line line;

    public Segment(Cartesian2D start, Cartesian2D end, Line line) {
        this.start = start;
        this.end = end;
        this.line = line;
    }

    public Cartesian2D getStart() {
        return this.start;
    }

    public Cartesian2D getEnd() {
        return this.end;
    }

    public Line getLine() {
        return this.line;
    }

    public double distance(Cartesian2D p) {
        double deltaX = this.end.getX() - this.start.getX();
        double deltaY = this.end.getY() - this.start.getY();
        double r = ((p.getX() - this.start.getX()) * deltaX + (p.getY() - this.start.getY()) * deltaY) / (deltaX * deltaX + deltaY * deltaY);
        if (r < 0.0 || r > 1.0) {
            double dist1 = this.getStart().distance((Point<Euclidean2D>)p);
            double dist2 = this.getEnd().distance((Point<Euclidean2D>)p);
            return FastMath.min(dist1, dist2);
        }
        double px = this.start.getX() + r * deltaX;
        double py = this.start.getY() + r * deltaY;
        Cartesian2D interPt = new Cartesian2D(px, py);
        return interPt.distance((Point<Euclidean2D>)p);
    }
}

