/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.essentials.collections;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.greenrobot.essentials.collections.AbstractMultimap;

public class Multimap<K, V>
extends AbstractMultimap<K, V, List<V>> {
    private final ListType listType;

    public static <K, V> Multimap<K, V> create() {
        return Multimap.create(ListType.REGULAR);
    }

    public static <K, V> Multimap<K, V> create(ListType listType) {
        return new Multimap(new HashMap(), listType);
    }

    protected Multimap(Map<K, List<V>> map, ListType listType) {
        super(map);
        this.listType = listType;
        if (listType == null) {
            throw new IllegalArgumentException("List type may not be null");
        }
    }

    @Override
    protected List<V> createNewCollection() {
        switch (this.listType) {
            case REGULAR: {
                return new ArrayList();
            }
            case THREAD_SAFE: {
                return new CopyOnWriteArrayList();
            }
            case LINKED: {
                return new LinkedList();
            }
        }
        throw new IllegalStateException("Unknown list type: " + (Object)((Object)this.listType));
    }

    public static enum ListType {
        REGULAR,
        THREAD_SAFE,
        LINKED;

    }
}

