/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;

public class LogisticDistribution
extends AbstractContinuousDistribution {
    private static final double PI_SQUARED_OVER_THREE = 3.289868133696453;
    private final double mu;
    private final double scale;
    private final double oneOverScale;

    public LogisticDistribution(double d, double d2) {
        if (d2 <= 0.0) {
            throw new DistributionException("Number {0} is negative", d2);
        }
        this.mu = d;
        this.scale = d2;
        this.oneOverScale = 1.0 / d2;
    }

    public double getLocation() {
        return this.mu;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public double density(double d) {
        double d2 = this.oneOverScale * (d - this.mu);
        double d3 = Math.exp(-d2);
        return this.oneOverScale * d3 / ((1.0 + d3) * (1.0 + d3));
    }

    @Override
    public double cumulativeProbability(double d) {
        double d2 = this.oneOverScale * (d - this.mu);
        return 1.0 / (1.0 + Math.exp(-d2));
    }

    @Override
    public double inverseCumulativeProbability(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", d, 0, 1);
        }
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.scale * Math.log(d / (1.0 - d)) + this.mu;
    }

    @Override
    public double getMean() {
        return this.mu;
    }

    @Override
    public double getVariance() {
        return this.oneOverScale * this.oneOverScale * 3.289868133696453;
    }

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

