/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.MathArithmeticException;
import org.apache.commons.math4.exception.MathUnsupportedOperationException;
import org.apache.commons.math4.exception.MaxCountExceededException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.linear.Array2DRowRealMatrix;
import org.apache.commons.math4.linear.ArrayRealVector;
import org.apache.commons.math4.linear.DecompositionSolver;
import org.apache.commons.math4.linear.DiagonalMatrix;
import org.apache.commons.math4.linear.MatrixUtils;
import org.apache.commons.math4.linear.RealMatrix;
import org.apache.commons.math4.linear.RealVector;
import org.apache.commons.math4.linear.SchurTransformer;
import org.apache.commons.math4.linear.SingularMatrixException;
import org.apache.commons.math4.linear.TriDiagonalTransformer;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.numbers.complex.Complex;
import org.apache.commons.numbers.core.Precision;

public class EigenDecomposition {
    private static final double EPSILON = 1.0E-12;
    private static final byte MAX_ITER = 30;
    private double[] main;
    private double[] secondary;
    private TriDiagonalTransformer transformer;
    private double[] realEigenvalues;
    private double[] imagEigenvalues;
    private ArrayRealVector[] eigenvectors;
    private RealMatrix cachedV;
    private RealMatrix cachedD;
    private RealMatrix cachedVt;
    private final boolean isSymmetric;

    public EigenDecomposition(RealMatrix realMatrix) throws MathArithmeticException {
        double d = (double)(10 * realMatrix.getRowDimension() * realMatrix.getColumnDimension()) * Precision.EPSILON;
        this.isSymmetric = MatrixUtils.isSymmetric(realMatrix, d);
        if (this.isSymmetric) {
            this.transformToTridiagonal(realMatrix);
            this.findEigenVectors(this.transformer.getQ().getData());
        } else {
            SchurTransformer schurTransformer = this.transformToSchur(realMatrix);
            this.findEigenVectorsFromSchur(schurTransformer);
        }
    }

    public EigenDecomposition(double[] dArray, double[] dArray2) {
        this.isSymmetric = true;
        this.main = (double[])dArray.clone();
        this.secondary = (double[])dArray2.clone();
        this.transformer = null;
        int n = dArray.length;
        double[][] dArray3 = new double[n][n];
        for (int i = 0; i < n; ++i) {
            dArray3[i][i] = 1.0;
        }
        this.findEigenVectors(dArray3);
    }

    public RealMatrix getV() {
        if (this.cachedV == null) {
            int n = this.eigenvectors.length;
            this.cachedV = MatrixUtils.createRealMatrix(n, n);
            for (int i = 0; i < n; ++i) {
                this.cachedV.setColumnVector(i, this.eigenvectors[i]);
            }
        }
        return this.cachedV;
    }

    public RealMatrix getD() {
        if (this.cachedD == null) {
            this.cachedD = MatrixUtils.createRealMatrixWithDiagonal(this.realEigenvalues);
            for (int i = 0; i < this.imagEigenvalues.length; ++i) {
                if (Precision.compareTo(this.imagEigenvalues[i], 0.0, 1.0E-12) > 0) {
                    this.cachedD.setEntry(i, i + 1, this.imagEigenvalues[i]);
                    continue;
                }
                if (Precision.compareTo(this.imagEigenvalues[i], 0.0, 1.0E-12) >= 0) continue;
                this.cachedD.setEntry(i, i - 1, this.imagEigenvalues[i]);
            }
        }
        return this.cachedD;
    }

    public RealMatrix getVT() {
        if (this.cachedVt == null) {
            int n = this.eigenvectors.length;
            this.cachedVt = MatrixUtils.createRealMatrix(n, n);
            for (int i = 0; i < n; ++i) {
                this.cachedVt.setRowVector(i, this.eigenvectors[i]);
            }
        }
        return this.cachedVt;
    }

    public boolean hasComplexEigenvalues() {
        for (int i = 0; i < this.imagEigenvalues.length; ++i) {
            if (Precision.equals(this.imagEigenvalues[i], 0.0, 1.0E-12)) continue;
            return true;
        }
        return false;
    }

    public double[] getRealEigenvalues() {
        return (double[])this.realEigenvalues.clone();
    }

    public double getRealEigenvalue(int n) {
        return this.realEigenvalues[n];
    }

    public double[] getImagEigenvalues() {
        return (double[])this.imagEigenvalues.clone();
    }

    public double getImagEigenvalue(int n) {
        return this.imagEigenvalues[n];
    }

    public RealVector getEigenvector(int n) {
        return this.eigenvectors[n].copy();
    }

    public double getDeterminant() {
        double d = 1.0;
        for (double d2 : this.realEigenvalues) {
            d *= d2;
        }
        return d;
    }

    public RealMatrix getSquareRoot() {
        if (!this.isSymmetric) {
            throw new MathUnsupportedOperationException();
        }
        double[] dArray = new double[this.realEigenvalues.length];
        for (int i = 0; i < this.realEigenvalues.length; ++i) {
            double d = this.realEigenvalues[i];
            if (d <= 0.0) {
                throw new MathUnsupportedOperationException();
            }
            dArray[i] = FastMath.sqrt(d);
        }
        DiagonalMatrix diagonalMatrix = MatrixUtils.createRealDiagonalMatrix(dArray);
        RealMatrix realMatrix = this.getV();
        RealMatrix realMatrix2 = this.getVT();
        return realMatrix.multiply(diagonalMatrix).multiply(realMatrix2);
    }

    public DecompositionSolver getSolver() {
        if (this.hasComplexEigenvalues()) {
            throw new MathUnsupportedOperationException();
        }
        return new Solver(this.realEigenvalues, this.imagEigenvalues, this.eigenvectors);
    }

    private void transformToTridiagonal(RealMatrix realMatrix) {
        this.transformer = new TriDiagonalTransformer(realMatrix);
        this.main = this.transformer.getMainDiagonalRef();
        this.secondary = this.transformer.getSecondaryDiagonalRef();
    }

    private void findEigenVectors(double[][] dArray) {
        int n;
        int n2;
        double[][] dArray2 = (double[][])dArray.clone();
        int n3 = this.main.length;
        this.realEigenvalues = new double[n3];
        this.imagEigenvalues = new double[n3];
        double[] dArray3 = new double[n3];
        for (int i = 0; i < n3 - 1; ++i) {
            this.realEigenvalues[i] = this.main[i];
            dArray3[i] = this.secondary[i];
        }
        this.realEigenvalues[n3 - 1] = this.main[n3 - 1];
        dArray3[n3 - 1] = 0.0;
        double d = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (FastMath.abs(this.realEigenvalues[n2]) > d) {
                d = FastMath.abs(this.realEigenvalues[n2]);
            }
            if (!(FastMath.abs(dArray3[n2]) > d)) continue;
            d = FastMath.abs(dArray3[n2]);
        }
        if (d != 0.0) {
            for (n2 = 0; n2 < n3; ++n2) {
                if (FastMath.abs(this.realEigenvalues[n2]) <= Precision.EPSILON * d) {
                    this.realEigenvalues[n2] = 0.0;
                }
                if (!(FastMath.abs(dArray3[n2]) <= Precision.EPSILON * d)) continue;
                dArray3[n2] = 0.0;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n4;
            n = 0;
            do {
                int n5;
                double d2;
                for (n4 = n2; n4 < n3 - 1; ++n4) {
                    d2 = FastMath.abs(this.realEigenvalues[n4]) + FastMath.abs(this.realEigenvalues[n4 + 1]);
                    if (FastMath.abs(dArray3[n4]) + d2 == d2) break;
                }
                if (n4 == n2) continue;
                if (n == 30) {
                    throw new MaxCountExceededException((Localizable)LocalizedFormats.CONVERGENCE_FAILED, (byte)30, new Object[0]);
                }
                ++n;
                d2 = (this.realEigenvalues[n2 + 1] - this.realEigenvalues[n2]) / (2.0 * dArray3[n2]);
                double d3 = FastMath.sqrt(1.0 + d2 * d2);
                d2 = d2 < 0.0 ? this.realEigenvalues[n4] - this.realEigenvalues[n2] + dArray3[n2] / (d2 - d3) : this.realEigenvalues[n4] - this.realEigenvalues[n2] + dArray3[n2] / (d2 + d3);
                double d4 = 0.0;
                double d5 = 1.0;
                double d6 = 1.0;
                for (n5 = n4 - 1; n5 >= n2; --n5) {
                    double d7 = d5 * dArray3[n5];
                    double d8 = d6 * dArray3[n5];
                    if (FastMath.abs(d7) >= FastMath.abs(d2)) {
                        d6 = d2 / d7;
                        d3 = FastMath.sqrt(d6 * d6 + 1.0);
                        dArray3[n5 + 1] = d7 * d3;
                        d5 = 1.0 / d3;
                        d6 *= d5;
                    } else {
                        d5 = d7 / d2;
                        d3 = FastMath.sqrt(d5 * d5 + 1.0);
                        dArray3[n5 + 1] = d2 * d3;
                        d6 = 1.0 / d3;
                        d5 *= d6;
                    }
                    if (dArray3[n5 + 1] == 0.0) {
                        int n6 = n5 + 1;
                        this.realEigenvalues[n6] = this.realEigenvalues[n6] - d4;
                        dArray3[n4] = 0.0;
                        break;
                    }
                    d2 = this.realEigenvalues[n5 + 1] - d4;
                    d3 = (this.realEigenvalues[n5] - d2) * d5 + 2.0 * d6 * d8;
                    d4 = d5 * d3;
                    this.realEigenvalues[n5 + 1] = d2 + d4;
                    d2 = d6 * d3 - d8;
                    for (int i = 0; i < n3; ++i) {
                        d7 = dArray2[i][n5 + 1];
                        dArray2[i][n5 + 1] = d5 * dArray2[i][n5] + d6 * d7;
                        dArray2[i][n5] = d6 * dArray2[i][n5] - d5 * d7;
                    }
                }
                if (d3 == 0.0 && n5 >= n2) continue;
                int n7 = n2;
                this.realEigenvalues[n7] = this.realEigenvalues[n7] - d4;
                dArray3[n2] = d2;
                dArray3[n4] = 0.0;
            } while (n4 != n2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n8;
            n = n2;
            double d9 = this.realEigenvalues[n2];
            for (n8 = n2 + 1; n8 < n3; ++n8) {
                if (!(this.realEigenvalues[n8] > d9)) continue;
                n = n8;
                d9 = this.realEigenvalues[n8];
            }
            if (n == n2) continue;
            this.realEigenvalues[n] = this.realEigenvalues[n2];
            this.realEigenvalues[n2] = d9;
            for (n8 = 0; n8 < n3; ++n8) {
                d9 = dArray2[n8][n2];
                dArray2[n8][n2] = dArray2[n8][n];
                dArray2[n8][n] = d9;
            }
        }
        d = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!(FastMath.abs(this.realEigenvalues[n2]) > d)) continue;
            d = FastMath.abs(this.realEigenvalues[n2]);
        }
        if (d != 0.0) {
            for (n2 = 0; n2 < n3; ++n2) {
                if (!(FastMath.abs(this.realEigenvalues[n2]) < Precision.EPSILON * d)) continue;
                this.realEigenvalues[n2] = 0.0;
            }
        }
        this.eigenvectors = new ArrayRealVector[n3];
        double[] dArray4 = new double[n3];
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n3; ++i) {
                dArray4[i] = dArray2[i][n];
            }
            this.eigenvectors[n] = new ArrayRealVector(dArray4);
        }
    }

    private SchurTransformer transformToSchur(RealMatrix realMatrix) {
        SchurTransformer schurTransformer = new SchurTransformer(realMatrix);
        double[][] dArray = schurTransformer.getT().getData();
        this.realEigenvalues = new double[dArray.length];
        this.imagEigenvalues = new double[dArray.length];
        for (int i = 0; i < this.realEigenvalues.length; ++i) {
            if (i == this.realEigenvalues.length - 1 || Precision.equals(dArray[i + 1][i], 0.0, 1.0E-12)) {
                this.realEigenvalues[i] = dArray[i][i];
                continue;
            }
            double d = dArray[i + 1][i + 1];
            double d2 = 0.5 * (dArray[i][i] - d);
            double d3 = FastMath.sqrt(FastMath.abs(d2 * d2 + dArray[i + 1][i] * dArray[i][i + 1]));
            this.realEigenvalues[i] = d + d2;
            this.imagEigenvalues[i] = d3;
            this.realEigenvalues[i + 1] = d + d2;
            this.imagEigenvalues[i + 1] = -d3;
            ++i;
        }
        return schurTransformer;
    }

    private Complex cdiv(double d, double d2, double d3, double d4) {
        return Complex.ofCartesian(d, d2).divide(Complex.ofCartesian(d3, d4));
    }

    private void findEigenVectorsFromSchur(SchurTransformer schurTransformer) throws MathArithmeticException {
        int n;
        int n2;
        double[][] dArray = schurTransformer.getT().getData();
        double[][] dArray2 = schurTransformer.getP().getData();
        int n3 = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n3; ++i) {
            for (int j = FastMath.max(i - 1, 0); j < n3; ++j) {
                d += FastMath.abs(dArray[i][j]);
            }
        }
        if (Precision.equals(d, 0.0, 1.0E-12)) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            double d5;
            double d6;
            double d7;
            int n4;
            int n5;
            double d8 = this.realEigenvalues[n2];
            double d9 = this.imagEigenvalues[n2];
            if (Precision.equals(d9, 0.0)) {
                n5 = n2;
                dArray[n2][n2] = 1.0;
                for (n4 = n2 - 1; n4 >= 0; --n4) {
                    d7 = dArray[n4][n4] - d8;
                    d2 = 0.0;
                    for (int i = n5; i <= n2; ++i) {
                        d2 += dArray[n4][i] * dArray[i][n2];
                    }
                    if (Precision.compareTo(this.imagEigenvalues[n4], 0.0, 1.0E-12) < 0) {
                        d4 = d7;
                        d3 = d2;
                        continue;
                    }
                    n5 = n4;
                    if (Precision.equals(this.imagEigenvalues[n4], 0.0)) {
                        dArray[n4][n2] = d7 != 0.0 ? -d2 / d7 : -d2 / (Precision.EPSILON * d);
                    } else {
                        double d10 = dArray[n4][n4 + 1];
                        d6 = dArray[n4 + 1][n4];
                        d9 = (this.realEigenvalues[n4] - d8) * (this.realEigenvalues[n4] - d8) + this.imagEigenvalues[n4] * this.imagEigenvalues[n4];
                        dArray[n4][n2] = d5 = (d10 * d3 - d4 * d2) / d9;
                        dArray[n4 + 1][n2] = FastMath.abs(d10) > FastMath.abs(d4) ? (-d2 - d7 * d5) / d10 : (-d3 - d6 * d5) / d4;
                    }
                    double d11 = FastMath.abs(dArray[n4][n2]);
                    if (!(Precision.EPSILON * d11 * d11 > 1.0)) continue;
                    for (int i = n4; i <= n2; ++i) {
                        double[] dArray3 = dArray[i];
                        int n6 = n2;
                        dArray3[n6] = dArray3[n6] / d11;
                    }
                }
                continue;
            }
            if (!(d9 < 0.0)) continue;
            n5 = n2 - 1;
            if (FastMath.abs(dArray[n2][n2 - 1]) > FastMath.abs(dArray[n2 - 1][n2])) {
                dArray[n2 - 1][n2 - 1] = d9 / dArray[n2][n2 - 1];
                dArray[n2 - 1][n2] = -(dArray[n2][n2] - d8) / dArray[n2][n2 - 1];
            } else {
                Complex complex = this.cdiv(0.0, -dArray[n2 - 1][n2], dArray[n2 - 1][n2 - 1] - d8, d9);
                dArray[n2 - 1][n2 - 1] = complex.getReal();
                dArray[n2 - 1][n2] = complex.getImaginary();
            }
            dArray[n2][n2 - 1] = 0.0;
            dArray[n2][n2] = 1.0;
            for (n4 = n2 - 2; n4 >= 0; --n4) {
                d7 = 0.0;
                double d12 = 0.0;
                for (int i = n5; i <= n2; ++i) {
                    d7 += dArray[n4][i] * dArray[i][n2 - 1];
                    d12 += dArray[n4][i] * dArray[i][n2];
                }
                d6 = dArray[n4][n4] - d8;
                if (Precision.compareTo(this.imagEigenvalues[n4], 0.0, 1.0E-12) < 0) {
                    d4 = d6;
                    d2 = d7;
                    d3 = d12;
                    continue;
                }
                n5 = n4;
                if (Precision.equals(this.imagEigenvalues[n4], 0.0)) {
                    Complex complex = this.cdiv(-d7, -d12, d6, d9);
                    dArray[n4][n2 - 1] = complex.getReal();
                    dArray[n4][n2] = complex.getImaginary();
                } else {
                    d5 = dArray[n4][n4 + 1];
                    double d13 = dArray[n4 + 1][n4];
                    double d14 = (this.realEigenvalues[n4] - d8) * (this.realEigenvalues[n4] - d8) + this.imagEigenvalues[n4] * this.imagEigenvalues[n4] - d9 * d9;
                    double d15 = (this.realEigenvalues[n4] - d8) * 2.0 * d9;
                    if (Precision.equals(d14, 0.0) && Precision.equals(d15, 0.0)) {
                        d14 = Precision.EPSILON * d * (FastMath.abs(d6) + FastMath.abs(d9) + FastMath.abs(d5) + FastMath.abs(d13) + FastMath.abs(d4));
                    }
                    Complex complex = this.cdiv(d5 * d2 - d4 * d7 + d9 * d12, d5 * d3 - d4 * d12 - d9 * d7, d14, d15);
                    dArray[n4][n2 - 1] = complex.getReal();
                    dArray[n4][n2] = complex.getImaginary();
                    if (FastMath.abs(d5) > FastMath.abs(d4) + FastMath.abs(d9)) {
                        dArray[n4 + 1][n2 - 1] = (-d7 - d6 * dArray[n4][n2 - 1] + d9 * dArray[n4][n2]) / d5;
                        dArray[n4 + 1][n2] = (-d12 - d6 * dArray[n4][n2] - d9 * dArray[n4][n2 - 1]) / d5;
                    } else {
                        Complex complex2 = this.cdiv(-d2 - d13 * dArray[n4][n2 - 1], -d3 - d13 * dArray[n4][n2], d4, d9);
                        dArray[n4 + 1][n2 - 1] = complex2.getReal();
                        dArray[n4 + 1][n2] = complex2.getImaginary();
                    }
                }
                d5 = FastMath.max(FastMath.abs(dArray[n4][n2 - 1]), FastMath.abs(dArray[n4][n2]));
                if (!(Precision.EPSILON * d5 * d5 > 1.0)) continue;
                for (int i = n4; i <= n2; ++i) {
                    double[] dArray4 = dArray[i];
                    int n7 = n2 - 1;
                    dArray4[n7] = dArray4[n7] / d5;
                    double[] dArray5 = dArray[i];
                    int n8 = n2;
                    dArray5[n8] = dArray5[n8] / d5;
                }
            }
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            for (int i = 0; i <= n3 - 1; ++i) {
                d4 = 0.0;
                for (n = 0; n <= FastMath.min(n2, n3 - 1); ++n) {
                    d4 += dArray2[i][n] * dArray[n][n2];
                }
                dArray2[i][n2] = d4;
            }
        }
        this.eigenvectors = new ArrayRealVector[n3];
        double[] dArray6 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            for (n = 0; n < n3; ++n) {
                dArray6[n] = dArray2[n][i];
            }
            this.eigenvectors[i] = new ArrayRealVector(dArray6);
        }
    }

    private static class Solver
    implements DecompositionSolver {
        private final double[] realEigenvalues;
        private final double[] imagEigenvalues;
        private final ArrayRealVector[] eigenvectors;

        private Solver(double[] dArray, double[] dArray2, ArrayRealVector[] arrayRealVectorArray) {
            this.realEigenvalues = dArray;
            this.imagEigenvalues = dArray2;
            this.eigenvectors = arrayRealVectorArray;
        }

        @Override
        public RealVector solve(RealVector realVector) {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int n = this.realEigenvalues.length;
            if (realVector.getDimension() != n) {
                throw new DimensionMismatchException(realVector.getDimension(), n);
            }
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                ArrayRealVector arrayRealVector = this.eigenvectors[i];
                double[] dArray2 = arrayRealVector.getDataRef();
                double d = arrayRealVector.dotProduct(realVector) / this.realEigenvalues[i];
                for (int j = 0; j < n; ++j) {
                    int n2 = j;
                    dArray[n2] = dArray[n2] + d * dArray2[j];
                }
            }
            return new ArrayRealVector(dArray, false);
        }

        @Override
        public RealMatrix solve(RealMatrix realMatrix) {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int n = this.realEigenvalues.length;
            if (realMatrix.getRowDimension() != n) {
                throw new DimensionMismatchException(realMatrix.getRowDimension(), n);
            }
            int n2 = realMatrix.getColumnDimension();
            double[][] dArray = new double[n][n2];
            double[] dArray2 = new double[n];
            for (int i = 0; i < n2; ++i) {
                int n3;
                for (n3 = 0; n3 < n; ++n3) {
                    dArray2[n3] = realMatrix.getEntry(n3, i);
                    dArray[n3][i] = 0.0;
                }
                for (n3 = 0; n3 < n; ++n3) {
                    int n4;
                    ArrayRealVector arrayRealVector = this.eigenvectors[n3];
                    double[] dArray3 = arrayRealVector.getDataRef();
                    double d = 0.0;
                    for (n4 = 0; n4 < n; ++n4) {
                        d += arrayRealVector.getEntry(n4) * dArray2[n4];
                    }
                    d /= this.realEigenvalues[n3];
                    for (n4 = 0; n4 < n; ++n4) {
                        double[] dArray4 = dArray[n4];
                        int n5 = i;
                        dArray4[n5] = dArray4[n5] + d * dArray3[n4];
                    }
                }
            }
            return new Array2DRowRealMatrix(dArray, false);
        }

        @Override
        public boolean isNonSingular() {
            int n;
            double d = 0.0;
            for (n = 0; n < this.realEigenvalues.length; ++n) {
                d = FastMath.max(d, this.eigenvalueNorm(n));
            }
            if (d == 0.0) {
                return false;
            }
            for (n = 0; n < this.realEigenvalues.length; ++n) {
                if (!Precision.equals(this.eigenvalueNorm(n) / d, 0.0, 1.0E-12)) continue;
                return false;
            }
            return true;
        }

        private double eigenvalueNorm(int n) {
            double d = this.realEigenvalues[n];
            double d2 = this.imagEigenvalues[n];
            return FastMath.sqrt(d * d + d2 * d2);
        }

        @Override
        public RealMatrix getInverse() {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int n = this.realEigenvalues.length;
            double[][] dArray = new double[n][n];
            for (int i = 0; i < n; ++i) {
                double[] dArray2 = dArray[i];
                for (int j = 0; j < n; ++j) {
                    double d = 0.0;
                    for (int k = 0; k < n; ++k) {
                        double[] dArray3 = this.eigenvectors[k].getDataRef();
                        d += dArray3[i] * dArray3[j] / this.realEigenvalues[k];
                    }
                    dArray2[j] = d;
                }
            }
            return MatrixUtils.createRealMatrix(dArray);
        }
    }
}

