/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.linear.Array2DRowRealMatrix;
import org.apache.commons.math4.linear.DecompositionSolver;
import org.apache.commons.math4.linear.DefaultRealMatrixPreservingVisitor;
import org.apache.commons.math4.linear.MatrixUtils;
import org.apache.commons.math4.linear.RealMatrix;
import org.apache.commons.math4.linear.RealVector;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.numbers.core.Precision;

public class SingularValueDecomposition {
    private static final double EPS = 2.220446049250313E-16;
    private static final double TINY = 1.6033346880071782E-291;
    private final double[] singularValues;
    private final int m;
    private final int n;
    private final boolean transposed;
    private final RealMatrix cachedU;
    private RealMatrix cachedUt;
    private RealMatrix cachedS;
    private final RealMatrix cachedV;
    private RealMatrix cachedVt;
    private final double tol;

    public SingularValueDecomposition(RealMatrix realMatrix) {
        int n;
        double d;
        int n2;
        int n3;
        double[][] dArray;
        if (realMatrix.getRowDimension() < realMatrix.getColumnDimension()) {
            this.transposed = true;
            dArray = realMatrix.transpose().getData();
            this.m = realMatrix.getColumnDimension();
            this.n = realMatrix.getRowDimension();
        } else {
            this.transposed = false;
            dArray = realMatrix.getData();
            this.m = realMatrix.getRowDimension();
            this.n = realMatrix.getColumnDimension();
        }
        this.singularValues = new double[this.n];
        double[][] dArray2 = new double[this.m][this.n];
        double[][] dArray3 = new double[this.n][this.n];
        double[] dArray4 = new double[this.n];
        double[] dArray5 = new double[this.m];
        int n4 = FastMath.min(this.m - 1, this.n);
        int n5 = FastMath.max(0, this.n - 2);
        for (n3 = 0; n3 < FastMath.max(n4, n5); ++n3) {
            int n6;
            if (n3 < n4) {
                this.singularValues[n3] = 0.0;
                for (n2 = n3; n2 < this.m; ++n2) {
                    this.singularValues[n3] = FastMath.hypot(this.singularValues[n3], dArray[n2][n3]);
                }
                if (this.singularValues[n3] != 0.0) {
                    if (dArray[n3][n3] < 0.0) {
                        this.singularValues[n3] = -this.singularValues[n3];
                    }
                    for (n2 = n3; n2 < this.m; ++n2) {
                        double[] dArray6 = dArray[n2];
                        int n7 = n3;
                        dArray6[n7] = dArray6[n7] / this.singularValues[n3];
                    }
                    double[] dArray7 = dArray[n3];
                    int n8 = n3;
                    dArray7[n8] = dArray7[n8] + 1.0;
                }
                this.singularValues[n3] = -this.singularValues[n3];
            }
            for (n2 = n3 + 1; n2 < this.n; ++n2) {
                if (n3 < n4 && this.singularValues[n3] != 0.0) {
                    double d2 = 0.0;
                    for (n6 = n3; n6 < this.m; ++n6) {
                        d2 += dArray[n6][n3] * dArray[n6][n2];
                    }
                    d2 = -d2 / dArray[n3][n3];
                    for (n6 = n3; n6 < this.m; ++n6) {
                        double[] dArray8 = dArray[n6];
                        int n9 = n2;
                        dArray8[n9] = dArray8[n9] + d2 * dArray[n6][n3];
                    }
                }
                dArray4[n2] = dArray[n3][n2];
            }
            if (n3 < n4) {
                for (n2 = n3; n2 < this.m; ++n2) {
                    dArray2[n2][n3] = dArray[n2][n3];
                }
            }
            if (n3 >= n5) continue;
            dArray4[n3] = 0.0;
            for (n2 = n3 + 1; n2 < this.n; ++n2) {
                dArray4[n3] = FastMath.hypot(dArray4[n3], dArray4[n2]);
            }
            if (dArray4[n3] != 0.0) {
                if (dArray4[n3 + 1] < 0.0) {
                    dArray4[n3] = -dArray4[n3];
                }
                n2 = n3 + 1;
                while (n2 < this.n) {
                    int n10 = n2++;
                    dArray4[n10] = dArray4[n10] / dArray4[n3];
                }
                int n11 = n3 + 1;
                dArray4[n11] = dArray4[n11] + 1.0;
            }
            dArray4[n3] = -dArray4[n3];
            if (n3 + 1 < this.m && dArray4[n3] != 0.0) {
                for (n2 = n3 + 1; n2 < this.m; ++n2) {
                    dArray5[n2] = 0.0;
                }
                for (n2 = n3 + 1; n2 < this.n; ++n2) {
                    for (int i = n3 + 1; i < this.m; ++i) {
                        int n12 = i;
                        dArray5[n12] = dArray5[n12] + dArray4[n2] * dArray[i][n2];
                    }
                }
                for (n2 = n3 + 1; n2 < this.n; ++n2) {
                    double d3 = -dArray4[n2] / dArray4[n3 + 1];
                    for (n6 = n3 + 1; n6 < this.m; ++n6) {
                        double[] dArray9 = dArray[n6];
                        int n13 = n2;
                        dArray9[n13] = dArray9[n13] + d3 * dArray5[n6];
                    }
                }
            }
            for (n2 = n3 + 1; n2 < this.n; ++n2) {
                dArray3[n2][n3] = dArray4[n2];
            }
        }
        n3 = this.n;
        if (n4 < this.n) {
            this.singularValues[n4] = dArray[n4][n4];
        }
        if (this.m < n3) {
            this.singularValues[n3 - 1] = 0.0;
        }
        if (n5 + 1 < n3) {
            dArray4[n5] = dArray[n5][n3 - 1];
        }
        dArray4[n3 - 1] = 0.0;
        for (n2 = n4; n2 < this.n; ++n2) {
            for (int i = 0; i < this.m; ++i) {
                dArray2[i][n2] = 0.0;
            }
            dArray2[n2][n2] = 1.0;
        }
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            int n14;
            if (this.singularValues[n2] != 0.0) {
                for (n14 = n2 + 1; n14 < this.n; ++n14) {
                    d = 0.0;
                    for (n = n2; n < this.m; ++n) {
                        d += dArray2[n][n2] * dArray2[n][n14];
                    }
                    d = -d / dArray2[n2][n2];
                    for (n = n2; n < this.m; ++n) {
                        double[] dArray10 = dArray2[n];
                        int n15 = n14;
                        dArray10[n15] = dArray10[n15] + d * dArray2[n][n2];
                    }
                }
                for (n14 = n2; n14 < this.m; ++n14) {
                    dArray2[n14][n2] = -dArray2[n14][n2];
                }
                dArray2[n2][n2] = 1.0 + dArray2[n2][n2];
                for (n14 = 0; n14 < n2 - 1; ++n14) {
                    dArray2[n14][n2] = 0.0;
                }
                continue;
            }
            for (n14 = 0; n14 < this.m; ++n14) {
                dArray2[n14][n2] = 0.0;
            }
            dArray2[n2][n2] = 1.0;
        }
        for (n2 = this.n - 1; n2 >= 0; --n2) {
            int n16;
            if (n2 < n5 && dArray4[n2] != 0.0) {
                for (n16 = n2 + 1; n16 < this.n; ++n16) {
                    d = 0.0;
                    for (n = n2 + 1; n < this.n; ++n) {
                        d += dArray3[n][n2] * dArray3[n][n16];
                    }
                    d = -d / dArray3[n2 + 1][n2];
                    for (n = n2 + 1; n < this.n; ++n) {
                        double[] dArray11 = dArray3[n];
                        int n17 = n16;
                        dArray11[n17] = dArray11[n17] + d * dArray3[n][n2];
                    }
                }
            }
            for (n16 = 0; n16 < this.n; ++n16) {
                dArray3[n16][n2] = 0.0;
            }
            dArray3[n2][n2] = 1.0;
        }
        n2 = n3 - 1;
        block34: while (n3 > 0) {
            int n18;
            int n19;
            for (n19 = n3 - 2; n19 >= 0; --n19) {
                double d4 = 1.6033346880071782E-291 + 2.220446049250313E-16 * (FastMath.abs(this.singularValues[n19]) + FastMath.abs(this.singularValues[n19 + 1]));
                if (FastMath.abs(dArray4[n19]) > d4) continue;
                dArray4[n19] = 0.0;
                break;
            }
            if (n19 == n3 - 2) {
                n18 = 4;
            } else {
                int n20;
                for (n20 = n3 - 1; n20 >= n19 && n20 != n19; --n20) {
                    double d5 = (n20 != n3 ? FastMath.abs(dArray4[n20]) : 0.0) + (n20 != n19 + 1 ? FastMath.abs(dArray4[n20 - 1]) : 0.0);
                    if (!(FastMath.abs(this.singularValues[n20]) <= 1.6033346880071782E-291 + 2.220446049250313E-16 * d5)) continue;
                    this.singularValues[n20] = 0.0;
                    break;
                }
                if (n20 == n19) {
                    n18 = 3;
                } else if (n20 == n3 - 1) {
                    n18 = 1;
                } else {
                    n18 = 2;
                    n19 = n20;
                }
            }
            ++n19;
            switch (n18) {
                case 1: {
                    int n21;
                    double d6;
                    double d7;
                    double d8;
                    double d9 = dArray4[n3 - 2];
                    dArray4[n3 - 2] = 0.0;
                    for (int i = n3 - 2; i >= n19; --i) {
                        d8 = FastMath.hypot(this.singularValues[i], d9);
                        d7 = this.singularValues[i] / d8;
                        d6 = d9 / d8;
                        this.singularValues[i] = d8;
                        if (i != n19) {
                            d9 = -d6 * dArray4[i - 1];
                            dArray4[i - 1] = d7 * dArray4[i - 1];
                        }
                        for (n21 = 0; n21 < this.n; ++n21) {
                            d8 = d7 * dArray3[n21][i] + d6 * dArray3[n21][n3 - 1];
                            dArray3[n21][n3 - 1] = -d6 * dArray3[n21][i] + d7 * dArray3[n21][n3 - 1];
                            dArray3[n21][i] = d8;
                        }
                    }
                    continue block34;
                }
                case 2: {
                    int n21;
                    double d6;
                    double d7;
                    double d8;
                    double d10 = dArray4[n19 - 1];
                    dArray4[n19 - 1] = 0.0;
                    for (int i = n19; i < n3; ++i) {
                        d8 = FastMath.hypot(this.singularValues[i], d10);
                        d7 = this.singularValues[i] / d8;
                        d6 = d10 / d8;
                        this.singularValues[i] = d8;
                        d10 = -d6 * dArray4[i];
                        dArray4[i] = d7 * dArray4[i];
                        for (n21 = 0; n21 < this.m; ++n21) {
                            d8 = d7 * dArray2[n21][i] + d6 * dArray2[n21][n19 - 1];
                            dArray2[n21][n19 - 1] = -d6 * dArray2[n21][i] + d7 * dArray2[n21][n19 - 1];
                            dArray2[n21][i] = d8;
                        }
                    }
                    continue block34;
                }
                case 3: {
                    double d11 = FastMath.max(FastMath.abs(this.singularValues[n3 - 1]), FastMath.abs(this.singularValues[n3 - 2]));
                    double d12 = FastMath.max(FastMath.max(FastMath.max(d11, FastMath.abs(dArray4[n3 - 2])), FastMath.abs(this.singularValues[n19])), FastMath.abs(dArray4[n19]));
                    double d13 = this.singularValues[n3 - 1] / d12;
                    double d14 = this.singularValues[n3 - 2] / d12;
                    double d15 = dArray4[n3 - 2] / d12;
                    double d16 = this.singularValues[n19] / d12;
                    double d17 = dArray4[n19] / d12;
                    double d18 = ((d14 + d13) * (d14 - d13) + d15 * d15) / 2.0;
                    double d19 = d13 * d15 * (d13 * d15);
                    double d20 = 0.0;
                    if (d18 != 0.0 || d19 != 0.0) {
                        d20 = FastMath.sqrt(d18 * d18 + d19);
                        if (d18 < 0.0) {
                            d20 = -d20;
                        }
                        d20 = d19 / (d18 + d20);
                    }
                    double d21 = (d16 + d13) * (d16 - d13) + d20;
                    double d22 = d16 * d17;
                    for (int i = n19; i < n3 - 1; ++i) {
                        int n22;
                        double d23 = FastMath.hypot(d21, d22);
                        double d24 = d21 / d23;
                        double d25 = d22 / d23;
                        if (i != n19) {
                            dArray4[i - 1] = d23;
                        }
                        d21 = d24 * this.singularValues[i] + d25 * dArray4[i];
                        dArray4[i] = d24 * dArray4[i] - d25 * this.singularValues[i];
                        d22 = d25 * this.singularValues[i + 1];
                        this.singularValues[i + 1] = d24 * this.singularValues[i + 1];
                        for (n22 = 0; n22 < this.n; ++n22) {
                            d23 = d24 * dArray3[n22][i] + d25 * dArray3[n22][i + 1];
                            dArray3[n22][i + 1] = -d25 * dArray3[n22][i] + d24 * dArray3[n22][i + 1];
                            dArray3[n22][i] = d23;
                        }
                        d23 = FastMath.hypot(d21, d22);
                        d24 = d21 / d23;
                        d25 = d22 / d23;
                        this.singularValues[i] = d23;
                        d21 = d24 * dArray4[i] + d25 * this.singularValues[i + 1];
                        this.singularValues[i + 1] = -d25 * dArray4[i] + d24 * this.singularValues[i + 1];
                        d22 = d25 * dArray4[i + 1];
                        dArray4[i + 1] = d24 * dArray4[i + 1];
                        if (i >= this.m - 1) continue;
                        for (n22 = 0; n22 < this.m; ++n22) {
                            d23 = d24 * dArray2[n22][i] + d25 * dArray2[n22][i + 1];
                            dArray2[n22][i + 1] = -d25 * dArray2[n22][i] + d24 * dArray2[n22][i + 1];
                            dArray2[n22][i] = d23;
                        }
                    }
                    dArray4[n3 - 2] = d21;
                    break;
                }
                default: {
                    if (this.singularValues[n19] <= 0.0) {
                        this.singularValues[n19] = this.singularValues[n19] < 0.0 ? -this.singularValues[n19] : 0.0;
                        for (int i = 0; i <= n2; ++i) {
                            dArray3[i][n19] = -dArray3[i][n19];
                        }
                    }
                    while (n19 < n2 && !(this.singularValues[n19] >= this.singularValues[n19 + 1])) {
                        int n23;
                        double d26 = this.singularValues[n19];
                        this.singularValues[n19] = this.singularValues[n19 + 1];
                        this.singularValues[n19 + 1] = d26;
                        if (n19 < this.n - 1) {
                            for (n23 = 0; n23 < this.n; ++n23) {
                                d26 = dArray3[n23][n19 + 1];
                                dArray3[n23][n19 + 1] = dArray3[n23][n19];
                                dArray3[n23][n19] = d26;
                            }
                        }
                        if (n19 < this.m - 1) {
                            for (n23 = 0; n23 < this.m; ++n23) {
                                d26 = dArray2[n23][n19 + 1];
                                dArray2[n23][n19 + 1] = dArray2[n23][n19];
                                dArray2[n23][n19] = d26;
                            }
                        }
                        ++n19;
                    }
                    --n3;
                }
            }
        }
        this.tol = FastMath.max((double)this.m * this.singularValues[0] * 2.220446049250313E-16, FastMath.sqrt(Precision.SAFE_MIN));
        if (!this.transposed) {
            this.cachedU = MatrixUtils.createRealMatrix(dArray2);
            this.cachedV = MatrixUtils.createRealMatrix(dArray3);
        } else {
            this.cachedU = MatrixUtils.createRealMatrix(dArray3);
            this.cachedV = MatrixUtils.createRealMatrix(dArray2);
        }
    }

    public RealMatrix getU() {
        return this.cachedU;
    }

    public RealMatrix getUT() {
        if (this.cachedUt == null) {
            this.cachedUt = this.getU().transpose();
        }
        return this.cachedUt;
    }

    public RealMatrix getS() {
        if (this.cachedS == null) {
            this.cachedS = MatrixUtils.createRealDiagonalMatrix(this.singularValues);
        }
        return this.cachedS;
    }

    public double[] getSingularValues() {
        return (double[])this.singularValues.clone();
    }

    public RealMatrix getV() {
        return this.cachedV;
    }

    public RealMatrix getVT() {
        if (this.cachedVt == null) {
            this.cachedVt = this.getV().transpose();
        }
        return this.cachedVt;
    }

    public RealMatrix getCovariance(double d) {
        int n;
        int n2 = this.singularValues.length;
        for (n = 0; n < n2 && this.singularValues[n] >= d; ++n) {
        }
        if (n == 0) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.TOO_LARGE_CUTOFF_SINGULAR_VALUE, (Number)d, this.singularValues[0], true);
        }
        final double[][] dArray = new double[n][n2];
        this.getVT().walkInOptimizedOrder(new DefaultRealMatrixPreservingVisitor(){

            @Override
            public void visit(int n, int n2, double d) {
                dArray[n][n2] = d / SingularValueDecomposition.this.singularValues[n];
            }
        }, 0, n - 1, 0, n2 - 1);
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(dArray, false);
        return array2DRowRealMatrix.transpose().multiply(array2DRowRealMatrix);
    }

    public double getNorm() {
        return this.singularValues[0];
    }

    public double getConditionNumber() {
        return this.singularValues[0] / this.singularValues[this.n - 1];
    }

    public double getInverseConditionNumber() {
        return this.singularValues[this.n - 1] / this.singularValues[0];
    }

    public int getRank() {
        int n = 0;
        for (int i = 0; i < this.singularValues.length; ++i) {
            if (!(this.singularValues[i] > this.tol)) continue;
            ++n;
        }
        return n;
    }

    public DecompositionSolver getSolver() {
        return new Solver(this.singularValues, this.getUT(), this.getV(), this.getRank() == this.m, this.tol);
    }

    private static class Solver
    implements DecompositionSolver {
        private final RealMatrix pseudoInverse;
        private final boolean nonSingular;

        private Solver(double[] dArray, RealMatrix realMatrix, RealMatrix realMatrix2, boolean bl, double d) {
            double[][] dArray2 = realMatrix.getData();
            for (int i = 0; i < dArray.length; ++i) {
                double d2 = dArray[i] > d ? 1.0 / dArray[i] : 0.0;
                double[] dArray3 = dArray2[i];
                int n = 0;
                while (n < dArray3.length) {
                    int n2 = n++;
                    dArray3[n2] = dArray3[n2] * d2;
                }
            }
            this.pseudoInverse = realMatrix2.multiply(new Array2DRowRealMatrix(dArray2, false));
            this.nonSingular = bl;
        }

        @Override
        public RealVector solve(RealVector realVector) {
            return this.pseudoInverse.operate(realVector);
        }

        @Override
        public RealMatrix solve(RealMatrix realMatrix) {
            return this.pseudoInverse.multiply(realMatrix);
        }

        @Override
        public boolean isNonSingular() {
            return this.nonSingular;
        }

        @Override
        public RealMatrix getInverse() {
            return this.pseudoInverse;
        }
    }
}

