/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.gamma;

import org.apache.commons.numbers.gamma.GammaException;

class InvGamma1pm1 {
    private static final double INV_GAMMA1P_M1_A0 = 6.116095104481416E-9;
    private static final double INV_GAMMA1P_M1_A1 = 6.247308301164655E-9;
    private static final double INV_GAMMA1P_M1_B1 = 0.203610414066807;
    private static final double INV_GAMMA1P_M1_B2 = 0.026620534842894922;
    private static final double INV_GAMMA1P_M1_B3 = 4.939449793824468E-4;
    private static final double INV_GAMMA1P_M1_B4 = -8.514194324403149E-6;
    private static final double INV_GAMMA1P_M1_B5 = -6.4304548177935305E-6;
    private static final double INV_GAMMA1P_M1_B6 = 9.926418406727737E-7;
    private static final double INV_GAMMA1P_M1_B7 = -6.077618957228252E-8;
    private static final double INV_GAMMA1P_M1_B8 = 1.9575583661463974E-10;
    private static final double INV_GAMMA1P_M1_P0 = 6.116095104481416E-9;
    private static final double INV_GAMMA1P_M1_P1 = 6.8716741130671986E-9;
    private static final double INV_GAMMA1P_M1_P2 = 6.820161668496171E-10;
    private static final double INV_GAMMA1P_M1_P3 = 4.686843322948848E-11;
    private static final double INV_GAMMA1P_M1_P4 = 1.5728330277104463E-12;
    private static final double INV_GAMMA1P_M1_P5 = -1.2494415722763663E-13;
    private static final double INV_GAMMA1P_M1_P6 = 4.343529937408594E-15;
    private static final double INV_GAMMA1P_M1_Q1 = 0.3056961078365221;
    private static final double INV_GAMMA1P_M1_Q2 = 0.054642130860422966;
    private static final double INV_GAMMA1P_M1_Q3 = 0.004956830093825887;
    private static final double INV_GAMMA1P_M1_Q4 = 2.6923694661863613E-4;
    private static final double INV_GAMMA1P_M1_C = -0.42278433509846713;
    private static final double INV_GAMMA1P_M1_C0 = 0.5772156649015329;
    private static final double INV_GAMMA1P_M1_C1 = -0.6558780715202539;
    private static final double INV_GAMMA1P_M1_C2 = -0.04200263503409524;
    private static final double INV_GAMMA1P_M1_C3 = 0.16653861138229148;
    private static final double INV_GAMMA1P_M1_C4 = -0.04219773455554433;
    private static final double INV_GAMMA1P_M1_C5 = -0.009621971527876973;
    private static final double INV_GAMMA1P_M1_C6 = 0.0072189432466631;
    private static final double INV_GAMMA1P_M1_C7 = -0.0011651675918590652;
    private static final double INV_GAMMA1P_M1_C8 = -2.1524167411495098E-4;
    private static final double INV_GAMMA1P_M1_C9 = 1.280502823881162E-4;
    private static final double INV_GAMMA1P_M1_C10 = -2.013485478078824E-5;
    private static final double INV_GAMMA1P_M1_C11 = -1.2504934821426706E-6;
    private static final double INV_GAMMA1P_M1_C12 = 1.133027231981696E-6;
    private static final double INV_GAMMA1P_M1_C13 = -2.056338416977607E-7;

    InvGamma1pm1() {
    }

    public static double value(double d) {
        double d2;
        if (d < -0.5 || d > 1.5) {
            throw new GammaException("Number {0} is out of range [{1}, {2}]", d, -0.5, 1.5);
        }
        double d3 = d2 = d <= 0.5 ? d : d - 0.5 - 0.5;
        if (d2 < 0.0) {
            double d4 = 6.116095104481416E-9 + d2 * 6.247308301164655E-9;
            double d5 = 1.9575583661463974E-10;
            d5 = -6.077618957228252E-8 + d2 * d5;
            d5 = 9.926418406727737E-7 + d2 * d5;
            d5 = -6.4304548177935305E-6 + d2 * d5;
            d5 = -8.514194324403149E-6 + d2 * d5;
            d5 = 4.939449793824468E-4 + d2 * d5;
            d5 = 0.026620534842894922 + d2 * d5;
            d5 = 0.203610414066807 + d2 * d5;
            d5 = 1.0 + d2 * d5;
            double d6 = -2.056338416977607E-7 + d2 * (d4 / d5);
            d6 = 1.133027231981696E-6 + d2 * d6;
            d6 = -1.2504934821426706E-6 + d2 * d6;
            d6 = -2.013485478078824E-5 + d2 * d6;
            d6 = 1.280502823881162E-4 + d2 * d6;
            d6 = -2.1524167411495098E-4 + d2 * d6;
            d6 = -0.0011651675918590652 + d2 * d6;
            d6 = 0.0072189432466631 + d2 * d6;
            d6 = -0.009621971527876973 + d2 * d6;
            d6 = -0.04219773455554433 + d2 * d6;
            d6 = 0.16653861138229148 + d2 * d6;
            d6 = -0.04200263503409524 + d2 * d6;
            d6 = -0.6558780715202539 + d2 * d6;
            d6 = -0.42278433509846713 + d2 * d6;
            if (d > 0.5) {
                return d2 * d6 / d;
            }
            return d * (d6 + 0.5 + 0.5);
        }
        double d7 = 4.343529937408594E-15;
        d7 = -1.2494415722763663E-13 + d2 * d7;
        d7 = 1.5728330277104463E-12 + d2 * d7;
        d7 = 4.686843322948848E-11 + d2 * d7;
        d7 = 6.820161668496171E-10 + d2 * d7;
        d7 = 6.8716741130671986E-9 + d2 * d7;
        d7 = 6.116095104481416E-9 + d2 * d7;
        double d8 = 2.6923694661863613E-4;
        d8 = 0.004956830093825887 + d2 * d8;
        d8 = 0.054642130860422966 + d2 * d8;
        d8 = 0.3056961078365221 + d2 * d8;
        d8 = 1.0 + d2 * d8;
        double d9 = -2.056338416977607E-7 + d7 / d8 * d2;
        d9 = 1.133027231981696E-6 + d2 * d9;
        d9 = -1.2504934821426706E-6 + d2 * d9;
        d9 = -2.013485478078824E-5 + d2 * d9;
        d9 = 1.280502823881162E-4 + d2 * d9;
        d9 = -2.1524167411495098E-4 + d2 * d9;
        d9 = -0.0011651675918590652 + d2 * d9;
        d9 = 0.0072189432466631 + d2 * d9;
        d9 = -0.009621971527876973 + d2 * d9;
        d9 = -0.04219773455554433 + d2 * d9;
        d9 = 0.16653861138229148 + d2 * d9;
        d9 = -0.04200263503409524 + d2 * d9;
        d9 = -0.6558780715202539 + d2 * d9;
        d9 = 0.5772156649015329 + d2 * d9;
        if (d > 0.5) {
            return d2 / d * (d9 - 0.5 - 0.5);
        }
        return d * d9;
    }
}

