/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.discrete.common;

import io.virtdata.discrete.common.ThreadSafeHash;
import java.util.function.DoubleToIntFunction;
import java.util.function.IntUnaryOperator;

public class InterpolatingIntIntSampler
implements IntUnaryOperator {
    private final double[] lut;
    private final DoubleToIntFunction f;
    private int resolution;
    private ThreadSafeHash hash;

    public InterpolatingIntIntSampler(DoubleToIntFunction doubleToIntFunction, int n, boolean bl) {
        this.f = doubleToIntFunction;
        this.resolution = n;
        if (bl) {
            this.hash = new ThreadSafeHash();
        }
        this.lut = this.precompute();
    }

    private double[] precompute() {
        double[] dArray = new double[this.resolution + 2];
        for (int i = 0; i <= this.resolution; ++i) {
            double d = (double)i / (double)this.resolution;
            int n = this.f.applyAsInt(d);
            dArray[i] = n;
        }
        dArray[dArray.length - 1] = 0.0;
        return dArray;
    }

    @Override
    public int applyAsInt(int n) {
        int n2 = n;
        if (this.hash != null) {
            n2 = (int)(this.hash.applyAsLong(n) % Integer.MAX_VALUE);
        }
        double d = (double)n2 / 2.147483647E9;
        double d2 = d * (double)this.resolution;
        int n3 = (int)d2;
        double d3 = d2 - (double)n3;
        double d4 = this.lut[n3] * (1.0 - d3);
        double d5 = this.lut[n3 + 1] * d3;
        double d6 = d4 + d5;
        return (int)d6;
    }
}

