/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.descriptive.moment;

import io.virtdata.shaded.oac.statistics.descriptive.AbstractUnivariateStatistic;
import io.virtdata.shaded.oac.statistics.descriptive.moment.Mean;
import java.io.Serializable;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.MathUtils;

public class SemiVariance
extends AbstractUnivariateStatistic
implements Serializable {
    public static final Direction UPSIDE_VARIANCE = Direction.UPSIDE;
    public static final Direction DOWNSIDE_VARIANCE = Direction.DOWNSIDE;
    private static final long serialVersionUID = 20150412L;
    private boolean biasCorrected = true;
    private Direction varianceDirection = Direction.DOWNSIDE;

    public SemiVariance() {
    }

    public SemiVariance(boolean bl) {
        this.biasCorrected = bl;
    }

    public SemiVariance(Direction direction) {
        this.varianceDirection = direction;
    }

    public SemiVariance(boolean bl, Direction direction) {
        this.biasCorrected = bl;
        this.varianceDirection = direction;
    }

    public SemiVariance(SemiVariance semiVariance) throws NullArgumentException {
        SemiVariance.copy(semiVariance, this);
    }

    @Override
    public SemiVariance copy() {
        SemiVariance semiVariance = new SemiVariance();
        SemiVariance.copy(this, semiVariance);
        return semiVariance;
    }

    public static void copy(SemiVariance semiVariance, SemiVariance semiVariance2) throws NullArgumentException {
        MathUtils.checkNotNull(semiVariance);
        MathUtils.checkNotNull(semiVariance2);
        semiVariance2.biasCorrected = semiVariance.biasCorrected;
        semiVariance2.varianceDirection = semiVariance.varianceDirection;
    }

    @Override
    public double evaluate(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        double d = new Mean().evaluate(dArray, n, n2);
        return this.evaluate(dArray, d, this.varianceDirection, this.biasCorrected, 0, dArray.length);
    }

    public double evaluate(double[] dArray, Direction direction) throws MathIllegalArgumentException {
        double d = new Mean().evaluate(dArray);
        return this.evaluate(dArray, d, direction, this.biasCorrected, 0, dArray.length);
    }

    public double evaluate(double[] dArray, double d) throws MathIllegalArgumentException {
        return this.evaluate(dArray, d, this.varianceDirection, this.biasCorrected, 0, dArray.length);
    }

    public double evaluate(double[] dArray, double d, Direction direction) throws MathIllegalArgumentException {
        return this.evaluate(dArray, d, direction, this.biasCorrected, 0, dArray.length);
    }

    public double evaluate(double[] dArray, double d, Direction direction, boolean bl, int n, int n2) throws MathIllegalArgumentException {
        MathArrays.verifyValues(dArray, n, n2);
        if (dArray.length == 0) {
            return Double.NaN;
        }
        if (dArray.length == 1) {
            return 0.0;
        }
        boolean bl2 = direction.getDirection();
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = n; i < n2; ++i) {
            if (dArray[i] > d != bl2) continue;
            d2 = dArray[i] - d;
            d3 += d2 * d2;
        }
        if (bl) {
            return d3 / ((double)n2 - 1.0);
        }
        return d3 / (double)n2;
    }

    public boolean isBiasCorrected() {
        return this.biasCorrected;
    }

    public void setBiasCorrected(boolean bl) {
        this.biasCorrected = bl;
    }

    public Direction getVarianceDirection() {
        return this.varianceDirection;
    }

    public void setVarianceDirection(Direction direction) {
        this.varianceDirection = direction;
    }

    public static enum Direction {
        UPSIDE(true),
        DOWNSIDE(false);

        private boolean direction;

        private Direction(boolean bl) {
            this.direction = bl;
        }

        boolean getDirection() {
            return this.direction;
        }
    }
}

