/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.numbers.gamma.Erfc;
import org.apache.commons.numbers.gamma.InverseErfc;

public class LevyDistribution
extends AbstractContinuousDistribution {
    private final double mu;
    private final double c;
    private final double halfC;

    public LevyDistribution(double d, double d2) {
        this.mu = d;
        this.c = d2;
        this.halfC = 0.5 * d2;
    }

    @Override
    public double density(double d) {
        if (d < this.mu) {
            return Double.NaN;
        }
        double d2 = d - this.mu;
        double d3 = this.halfC / d2;
        return Math.sqrt(d3 / Math.PI) * Math.exp(-d3) / d2;
    }

    @Override
    public double logDensity(double d) {
        if (d < this.mu) {
            return Double.NaN;
        }
        double d2 = d - this.mu;
        double d3 = this.halfC / d2;
        return 0.5 * Math.log(d3 / Math.PI) - d3 - Math.log(d2);
    }

    @Override
    public double cumulativeProbability(double d) {
        if (d < this.mu) {
            return Double.NaN;
        }
        return Erfc.value(Math.sqrt(this.halfC / (d - this.mu)));
    }

    @Override
    public double inverseCumulativeProbability(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", d, 0, 1);
        }
        double d2 = InverseErfc.value(d);
        return this.mu + this.halfC / (d2 * d2);
    }

    public double getScale() {
        return this.c;
    }

    public double getLocation() {
        return this.mu;
    }

    @Override
    public double getMean() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getVariance() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getSupportLowerBound() {
        return this.mu;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

