/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.interval;

import io.virtdata.shaded.oac.statistics.distribution.NormalDistribution;
import io.virtdata.shaded.oac.statistics.interval.BinomialConfidenceInterval;
import io.virtdata.shaded.oac.statistics.interval.ConfidenceInterval;
import io.virtdata.shaded.oac.statistics.interval.IntervalUtils;
import org.apache.commons.math4.util.FastMath;

public class AgrestiCoullInterval
implements BinomialConfidenceInterval {
    @Override
    public ConfidenceInterval createInterval(int n, int n2, double d) {
        IntervalUtils.checkParameters(n, n2, d);
        double d2 = (1.0 - d) / 2.0;
        NormalDistribution normalDistribution = new NormalDistribution(0.0, 1.0);
        double d3 = normalDistribution.inverseCumulativeProbability(1.0 - d2);
        double d4 = FastMath.pow(d3, 2);
        double d5 = (double)n + d4;
        double d6 = 1.0 / d5 * ((double)n2 + 0.5 * d4);
        double d7 = d3 * FastMath.sqrt(1.0 / d5 * d6 * (1.0 - d6));
        return new ConfidenceInterval(d6 - d7, d6 + d7, d);
    }
}

