/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.interval;

import io.virtdata.shaded.oac.statistics.distribution.NormalDistribution;
import io.virtdata.shaded.oac.statistics.interval.BinomialConfidenceInterval;
import io.virtdata.shaded.oac.statistics.interval.ConfidenceInterval;
import io.virtdata.shaded.oac.statistics.interval.IntervalUtils;
import org.apache.commons.math4.util.FastMath;

public class WilsonScoreInterval
implements BinomialConfidenceInterval {
    @Override
    public ConfidenceInterval createInterval(int n, int n2, double d) {
        IntervalUtils.checkParameters(n, n2, d);
        double d2 = (1.0 - d) / 2.0;
        NormalDistribution normalDistribution = new NormalDistribution(0.0, 1.0);
        double d3 = normalDistribution.inverseCumulativeProbability(1.0 - d2);
        double d4 = d3 * d3;
        double d5 = 1.0 / (double)n;
        double d6 = d4 * d5;
        double d7 = d5 * (double)n2;
        double d8 = 1.0 / (1.0 + d6);
        double d9 = d7 + d6 / 2.0;
        double d10 = d3 * FastMath.sqrt(d5 * d7 * (1.0 - d7) + d5 * d6 / 4.0);
        double d11 = d8 * (d9 - d10);
        double d12 = d8 * (d9 + d10);
        return new ConfidenceInterval(d11, d12, d);
    }
}

