/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.core;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class Precision {
    public static final double EPSILON;
    public static final double SAFE_MIN;
    private static final long EXPONENT_OFFSET = 1023L;
    private static final long SGN_MASK = Long.MIN_VALUE;
    private static final int SGN_MASK_FLOAT = Integer.MIN_VALUE;
    private static final double POSITIVE_ZERO = 0.0;
    private static final long POSITIVE_ZERO_DOUBLE_BITS;
    private static final long NEGATIVE_ZERO_DOUBLE_BITS;
    private static final int POSITIVE_ZERO_FLOAT_BITS;
    private static final int NEGATIVE_ZERO_FLOAT_BITS;

    private Precision() {
    }

    public static int compareTo(double d, double d2, double d3) {
        if (Precision.equals(d, d2, d3)) {
            return 0;
        }
        if (d < d2) {
            return -1;
        }
        return 1;
    }

    public static int compareTo(double d, double d2, int n) {
        if (Precision.equals(d, d2, n)) {
            return 0;
        }
        if (d < d2) {
            return -1;
        }
        return 1;
    }

    public static boolean equals(float f, float f2) {
        return Precision.equals(f, f2, 1);
    }

    public static boolean equalsIncludingNaN(float f, float f2) {
        return f != f || f2 != f2 ? !(f != f ^ f2 != f2) : Precision.equals(f, f2, 1);
    }

    public static boolean equals(float f, float f2, float f3) {
        return Precision.equals(f, f2, 1) || Math.abs(f2 - f) <= f3;
    }

    public static boolean equalsIncludingNaN(float f, float f2, float f3) {
        return Precision.equalsIncludingNaN(f, f2) || Math.abs(f2 - f) <= f3;
    }

    public static boolean equals(float f, float f2, int n) {
        boolean bl;
        int n2;
        int n3 = Float.floatToRawIntBits(f);
        if (((n3 ^ (n2 = Float.floatToRawIntBits(f2))) & Integer.MIN_VALUE) == 0) {
            bl = Math.abs(n3 - n2) <= n;
        } else {
            int n4;
            int n5;
            if (n3 < n2) {
                n5 = n2 - POSITIVE_ZERO_FLOAT_BITS;
                n4 = n3 - NEGATIVE_ZERO_FLOAT_BITS;
            } else {
                n5 = n3 - POSITIVE_ZERO_FLOAT_BITS;
                n4 = n2 - NEGATIVE_ZERO_FLOAT_BITS;
            }
            bl = n5 > n ? false : n4 <= n - n5;
        }
        return bl && !Float.isNaN(f) && !Float.isNaN(f2);
    }

    public static boolean equalsIncludingNaN(float f, float f2, int n) {
        return f != f || f2 != f2 ? !(f != f ^ f2 != f2) : Precision.equals(f, f2, n);
    }

    public static boolean equals(double d, double d2) {
        return Precision.equals(d, d2, 1);
    }

    public static boolean equalsIncludingNaN(double d, double d2) {
        return d != d || d2 != d2 ? !(d != d ^ d2 != d2) : Precision.equals(d, d2, 1);
    }

    public static boolean equals(double d, double d2, double d3) {
        return Precision.equals(d, d2, 1) || Math.abs(d2 - d) <= d3;
    }

    public static boolean equalsWithRelativeTolerance(double d, double d2, double d3) {
        if (Precision.equals(d, d2, 1)) {
            return true;
        }
        double d4 = Math.max(Math.abs(d), Math.abs(d2));
        double d5 = Math.abs((d - d2) / d4);
        return d5 <= d3;
    }

    public static boolean equalsIncludingNaN(double d, double d2, double d3) {
        return Precision.equalsIncludingNaN(d, d2) || Math.abs(d2 - d) <= d3;
    }

    public static boolean equals(double d, double d2, int n) {
        boolean bl;
        long l;
        long l2 = Double.doubleToRawLongBits(d);
        if (((l2 ^ (l = Double.doubleToRawLongBits(d2))) & Long.MIN_VALUE) == 0L) {
            bl = Math.abs(l2 - l) <= (long)n;
        } else {
            long l3;
            long l4;
            if (l2 < l) {
                l4 = l - POSITIVE_ZERO_DOUBLE_BITS;
                l3 = l2 - NEGATIVE_ZERO_DOUBLE_BITS;
            } else {
                l4 = l2 - POSITIVE_ZERO_DOUBLE_BITS;
                l3 = l - NEGATIVE_ZERO_DOUBLE_BITS;
            }
            bl = l4 > (long)n ? false : l3 <= (long)n - l4;
        }
        return bl && !Double.isNaN(d) && !Double.isNaN(d2);
    }

    public static boolean equalsIncludingNaN(double d, double d2, int n) {
        return d != d || d2 != d2 ? !(d != d ^ d2 != d2) : Precision.equals(d, d2, n);
    }

    public static double round(double d, int n) {
        return Precision.round(d, n, RoundingMode.HALF_UP);
    }

    public static double round(double d, int n, RoundingMode roundingMode) {
        try {
            double d2 = new BigDecimal(Double.toString(d)).setScale(n, roundingMode).doubleValue();
            return d2 == 0.0 ? 0.0 * d : d2;
        }
        catch (NumberFormatException numberFormatException) {
            if (Double.isInfinite(d)) {
                return d;
            }
            return Double.NaN;
        }
    }

    public static double representableDelta(double d, double d2) {
        return d + d2 - d;
    }

    static {
        POSITIVE_ZERO_DOUBLE_BITS = Double.doubleToRawLongBits(0.0);
        NEGATIVE_ZERO_DOUBLE_BITS = Double.doubleToRawLongBits(-0.0);
        POSITIVE_ZERO_FLOAT_BITS = Float.floatToRawIntBits(0.0f);
        NEGATIVE_ZERO_FLOAT_BITS = Float.floatToRawIntBits(-0.0f);
        EPSILON = Double.longBitsToDouble(4368491638549381120L);
        SAFE_MIN = Double.longBitsToDouble(0x10000000000000L);
    }
}

