/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source32;

import java.util.Arrays;
import org.apache.commons.rng.core.source32.IntProvider;
import org.apache.commons.rng.core.util.NumberFactory;

public class MersenneTwister
extends IntProvider {
    private static final long INT_MASK_LONG = 0xFFFFFFFFL;
    private static final long UPPER_MASK_LONG = 0x80000000L;
    private static final long LOWER_MASK_LONG = Integer.MAX_VALUE;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int N = 624;
    private static final int M = 397;
    private static final int[] MAG01 = new int[]{0, -1727483681};
    private int[] mt = new int[624];
    private int mti;

    public MersenneTwister(int[] nArray) {
        this.setSeedInternal(nArray);
    }

    @Override
    protected byte[] getStateInternal() {
        int[] nArray = Arrays.copyOf(this.mt, 625);
        nArray[624] = this.mti;
        return this.composeStateInternal(NumberFactory.makeByteArray(nArray), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] byArray) {
        byte[][] byArray2 = this.splitStateInternal(byArray, 2500);
        int[] nArray = NumberFactory.makeIntArray(byArray2[0]);
        System.arraycopy(nArray, 0, this.mt, 0, 624);
        this.mti = nArray[624];
        super.setStateInternal(byArray2[1]);
    }

    private void setSeedInternal(int[] nArray) {
        MersenneTwister.fillStateMersenneTwister(this.mt, nArray);
        this.mti = 624;
    }

    private static void fillStateMersenneTwister(int[] nArray, int[] nArray2) {
        long l;
        long l2;
        long l3;
        int n;
        int n2;
        if (nArray2.length == 0) {
            nArray2 = new int[1];
        }
        int n3 = nArray.length;
        long l4 = 19650218L;
        nArray[0] = (int)l4;
        for (n2 = 1; n2 < n3; ++n2) {
            l4 = 1812433253L * (l4 ^ l4 >> 30) + (long)n2 & 0xFFFFFFFFL;
            nArray[n2] = (int)l4;
        }
        n2 = 1;
        int n4 = 0;
        for (n = Math.max(n3, nArray2.length); n > 0; --n) {
            l3 = (long)nArray[n2] & Integer.MAX_VALUE | (nArray[n2] < 0 ? 0x80000000L : 0L);
            l2 = (long)nArray[n2 - 1] & Integer.MAX_VALUE | (nArray[n2 - 1] < 0 ? 0x80000000L : 0L);
            l = (l3 ^ (l2 ^ l2 >> 30) * 1664525L) + (long)nArray2[n4] + (long)n4;
            nArray[n2] = (int)(l & 0xFFFFFFFFL);
            ++n4;
            if (++n2 >= n3) {
                nArray[0] = nArray[n3 - 1];
                n2 = 1;
            }
            if (n4 < nArray2.length) continue;
            n4 = 0;
        }
        for (n = n3 - 1; n > 0; --n) {
            l3 = (long)nArray[n2] & Integer.MAX_VALUE | (nArray[n2] < 0 ? 0x80000000L : 0L);
            l2 = (long)nArray[n2 - 1] & Integer.MAX_VALUE | (nArray[n2 - 1] < 0 ? 0x80000000L : 0L);
            l = (l3 ^ (l2 ^ l2 >> 30) * 1566083941L) - (long)n2;
            nArray[n2] = (int)(l & 0xFFFFFFFFL);
            if (++n2 < n3) continue;
            nArray[0] = nArray[n3 - 1];
            n2 = 1;
        }
        nArray[0] = Integer.MIN_VALUE;
    }

    @Override
    public int next() {
        int n;
        if (this.mti >= 624) {
            int n2;
            int n3;
            int n4 = this.mt[0];
            for (n3 = 0; n3 < 227; ++n3) {
                n2 = n4;
                n4 = this.mt[n3 + 1];
                n = n2 & Integer.MIN_VALUE | n4 & Integer.MAX_VALUE;
                this.mt[n3] = this.mt[n3 + 397] ^ n >>> 1 ^ MAG01[n & 1];
            }
            for (n3 = 227; n3 < 623; ++n3) {
                n2 = n4;
                n4 = this.mt[n3 + 1];
                n = n2 & Integer.MIN_VALUE | n4 & Integer.MAX_VALUE;
                this.mt[n3] = this.mt[n3 + -227] ^ n >>> 1 ^ MAG01[n & 1];
            }
            n = n4 & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ n >>> 1 ^ MAG01[n & 1];
            this.mti = 0;
        }
        n = this.mt[this.mti++];
        n ^= n >>> 11;
        n ^= n << 7 & 0x9D2C5680;
        n ^= n << 15 & 0xEFC60000;
        n ^= n >>> 18;
        return n;
    }
}

