/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratNormalizedGaussianSampler;

public class UnitSphereSampler {
    private final NormalizedGaussianSampler sampler;
    private final int dimension;

    public UnitSphereSampler(int n, UniformRandomProvider uniformRandomProvider) {
        if (n <= 0) {
            throw new IllegalArgumentException("Dimension must be strictly positive");
        }
        this.dimension = n;
        this.sampler = new ZigguratNormalizedGaussianSampler(uniformRandomProvider);
    }

    public double[] nextVector() {
        double[] dArray = new double[this.dimension];
        double d = 0.0;
        for (int i = 0; i < this.dimension; ++i) {
            double d2;
            dArray[i] = d2 = this.sampler.sample();
            d += d2 * d2;
        }
        if (d == 0.0) {
            return this.nextVector();
        }
        double d3 = 1.0 / Math.sqrt(d);
        int n = 0;
        while (n < this.dimension) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * d3;
        }
        return dArray;
    }
}

