/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;

public class ChengBetaSampler
extends SamplerBase
implements ContinuousSampler {
    private final double alphaShape;
    private final double betaShape;
    private final UniformRandomProvider rng;

    public ChengBetaSampler(UniformRandomProvider uniformRandomProvider, double d, double d2) {
        super(null);
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha is not strictly positive: " + d);
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta is not strictly positive: " + d2);
        }
        this.rng = uniformRandomProvider;
        this.alphaShape = d;
        this.betaShape = d2;
    }

    @Override
    public double sample() {
        double d = Math.min(this.alphaShape, this.betaShape);
        double d2 = Math.max(this.alphaShape, this.betaShape);
        if (d > 1.0) {
            return this.algorithmBB(d, d2);
        }
        return this.algorithmBC(d2, d);
    }

    @Override
    public String toString() {
        return "Cheng Beta deviate [" + this.rng.toString() + "]";
    }

    private double algorithmBB(double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11 = d + d2;
        double d12 = Math.sqrt((d11 - 2.0) / (2.0 * d * d2 - d11));
        double d13 = d + 1.0 / d12;
        do {
            d7 = this.rng.nextDouble();
            d4 = this.rng.nextDouble();
        } while (!((d10 = d + (d9 = d13 * (d8 = d12 * (Math.log(d7) - Math.log1p(-d7))) - 1.3862944) - (d6 = d * Math.exp(d8))) + 2.609438 >= 5.0 * (d5 = d7 * d7 * d4)) && !(d10 >= (d3 = Math.log(d5))) && d9 + d11 * (Math.log(d11) - Math.log(d2 + d6)) < d3);
        d6 = Math.min(d6, Double.MAX_VALUE);
        return this.equals(d, this.alphaShape) ? d6 / (d2 + d6) : d2 / (d2 + d6);
    }

    private double algorithmBC(double d, double d2) {
        double d3;
        double d4 = d + d2;
        double d5 = 1.0 / d2;
        double d6 = 1.0 + d - d2;
        double d7 = d6 * (0.0138889 + 0.0416667 * d2) / (d * d5 - 0.777778);
        double d8 = 0.25 + (0.5 + 0.25 / d6) * d2;
        while (true) {
            double d9;
            double d10 = this.rng.nextDouble();
            double d11 = this.rng.nextDouble();
            double d12 = d10 * d11;
            double d13 = d10 * d12;
            if (d10 < 0.5) {
                if (0.25 * d11 + d13 - d12 >= d7) {
                    continue;
                }
            } else {
                if (d13 <= 0.25) {
                    d9 = d5 * (Math.log(d10) - Math.log1p(-d10));
                    d3 = d * Math.exp(d9);
                    break;
                }
                if (d13 >= d8) continue;
            }
            d9 = d5 * (Math.log(d10) - Math.log1p(-d10));
            d3 = d * Math.exp(d9);
            if (d4 * (Math.log(d4) - Math.log(d2 + d3) + d9) - 1.3862944 >= Math.log(d13)) break;
        }
        d3 = Math.min(d3, Double.MAX_VALUE);
        return this.equals(d, this.alphaShape) ? d3 / (d2 + d3) : d2 / (d2 + d3);
    }

    private boolean equals(double d, double d2) {
        return Math.abs(d - d2) <= Double.MIN_VALUE;
    }
}

