/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.LargeMeanPoissonSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;
import org.apache.commons.rng.sampling.distribution.SmallMeanPoissonSampler;

public class PoissonSampler
extends SamplerBase
implements DiscreteSampler {
    static final double PIVOT = 40.0;
    private final DiscreteSampler poissonSamplerDelegate;

    public PoissonSampler(UniformRandomProvider uniformRandomProvider, double d) {
        super(null);
        this.poissonSamplerDelegate = d < 40.0 ? new SmallMeanPoissonSampler(uniformRandomProvider, d) : new LargeMeanPoissonSampler(uniformRandomProvider, d);
    }

    @Override
    public int sample() {
        return this.poissonSamplerDelegate.sample();
    }

    @Override
    public String toString() {
        return this.poissonSamplerDelegate.toString();
    }
}

