/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;

public class ZigguratNormalizedGaussianSampler
implements NormalizedGaussianSampler {
    private static final double R = 3.442619855899;
    private static final double ONE_OVER_R = 0.29047645161474317;
    private static final double V = 0.00991256303526217;
    private static final double MAX;
    private static final double ONE_OVER_MAX;
    private static final int LEN = 128;
    private static final int LAST = 127;
    private static final long[] K;
    private static final double[] W;
    private static final double[] F;
    private final UniformRandomProvider rng;

    public ZigguratNormalizedGaussianSampler(UniformRandomProvider uniformRandomProvider) {
        this.rng = uniformRandomProvider;
    }

    @Override
    public double sample() {
        long l = this.rng.nextLong();
        int n = (int)(l & 0x7FL);
        if (Math.abs(l) < K[n]) {
            return (double)l * W[n];
        }
        return this.fix(l, n);
    }

    public String toString() {
        return "Ziggurat normalized Gaussian deviate [" + this.rng.toString() + "]";
    }

    private double fix(long l, int n) {
        double d = (double)l * W[n];
        if (n == 0) {
            double d2;
            while ((d2 = -Math.log(this.rng.nextDouble())) + d2 < (d = -Math.log(this.rng.nextDouble()) * 0.29047645161474317) * d) {
            }
            double d3 = 3.442619855899 + d;
            return l > 0L ? d3 : -d3;
        }
        if (F[n] + this.rng.nextDouble() * (F[n - 1] - F[n]) < ZigguratNormalizedGaussianSampler.gauss(d)) {
            return d;
        }
        return this.sample();
    }

    private static double gauss(double d) {
        return Math.exp(-0.5 * d * d);
    }

    static {
        double d;
        MAX = Math.pow(2.0, 63.0);
        ONE_OVER_MAX = 1.0 / MAX;
        K = new long[128];
        W = new double[128];
        F = new double[128];
        double d2 = d = 3.442619855899;
        double d3 = ZigguratNormalizedGaussianSampler.gauss(d);
        double d4 = 0.00991256303526217 / d3;
        ZigguratNormalizedGaussianSampler.K[0] = (long)(d / d4 * MAX);
        ZigguratNormalizedGaussianSampler.K[1] = 0L;
        ZigguratNormalizedGaussianSampler.W[0] = d4 * ONE_OVER_MAX;
        ZigguratNormalizedGaussianSampler.W[127] = d * ONE_OVER_MAX;
        ZigguratNormalizedGaussianSampler.F[0] = 1.0;
        ZigguratNormalizedGaussianSampler.F[127] = d3;
        for (int i = 126; i >= 1; --i) {
            d = Math.sqrt(-2.0 * Math.log(0.00991256303526217 / d + d3));
            d3 = ZigguratNormalizedGaussianSampler.gauss(d);
            ZigguratNormalizedGaussianSampler.K[i + 1] = (long)(d / d2 * MAX);
            d2 = d;
            ZigguratNormalizedGaussianSampler.F[i] = d3;
            ZigguratNormalizedGaussianSampler.W[i] = d * ONE_OVER_MAX;
        }
    }
}

