/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.descriptive.moment;

import io.virtdata.shaded.oac.statistics.descriptive.AbstractStorelessUnivariateStatistic;
import io.virtdata.shaded.oac.statistics.descriptive.WeightedEvaluation;
import io.virtdata.shaded.oac.statistics.descriptive.moment.FirstMoment;
import io.virtdata.shaded.oac.statistics.descriptive.summary.Sum;
import java.io.Serializable;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.MathUtils;

public class Mean
extends AbstractStorelessUnivariateStatistic
implements Serializable,
WeightedEvaluation {
    private static final long serialVersionUID = 20150412L;
    protected FirstMoment moment;
    protected boolean incMoment;

    public Mean() {
        this.incMoment = true;
        this.moment = new FirstMoment();
    }

    public Mean(FirstMoment firstMoment) {
        this.moment = firstMoment;
        this.incMoment = false;
    }

    public Mean(Mean mean) throws NullArgumentException {
        Mean.copy(mean, this);
    }

    @Override
    public void increment(double d) {
        if (this.incMoment) {
            this.moment.increment(d);
        }
    }

    @Override
    public void clear() {
        if (this.incMoment) {
            this.moment.clear();
        }
    }

    @Override
    public double getResult() {
        return this.moment.m1;
    }

    @Override
    public long getN() {
        return this.moment.getN();
    }

    @Override
    public double evaluate(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        if (MathArrays.verifyValues(dArray, n, n2)) {
            Sum sum = new Sum();
            double d = n2;
            double d2 = sum.evaluate(dArray, n, n2) / d;
            double d3 = 0.0;
            for (int i = n; i < n + n2; ++i) {
                d3 += dArray[i] - d2;
            }
            return d2 + d3 / d;
        }
        return Double.NaN;
    }

    @Override
    public double evaluate(double[] dArray, double[] dArray2, int n, int n2) throws MathIllegalArgumentException {
        if (MathArrays.verifyValues(dArray, dArray2, n, n2)) {
            Sum sum = new Sum();
            double d = sum.evaluate(dArray2, n, n2);
            double d2 = sum.evaluate(dArray, dArray2, n, n2) / d;
            double d3 = 0.0;
            for (int i = n; i < n + n2; ++i) {
                d3 += dArray2[i] * (dArray[i] - d2);
            }
            return d2 + d3 / d;
        }
        return Double.NaN;
    }

    @Override
    public double evaluate(double[] dArray, double[] dArray2) throws MathIllegalArgumentException {
        return this.evaluate(dArray, dArray2, 0, dArray.length);
    }

    @Override
    public Mean copy() {
        Mean mean = new Mean();
        Mean.copy(this, mean);
        return mean;
    }

    public static void copy(Mean mean, Mean mean2) throws NullArgumentException {
        MathUtils.checkNotNull(mean);
        MathUtils.checkNotNull(mean2);
        mean2.incMoment = mean.incMoment;
        mean2.moment = mean.moment.copy();
    }
}

