/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.ContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.rng.UniformRandomProvider;

public class ConstantContinuousDistribution
extends AbstractContinuousDistribution {
    private final double value;

    public ConstantContinuousDistribution(double d) {
        this.value = d;
    }

    @Override
    public double density(double d) {
        return d == this.value ? 1.0 : 0.0;
    }

    @Override
    public double cumulativeProbability(double d) {
        return d < this.value ? 0.0 : 1.0;
    }

    @Override
    public double inverseCumulativeProbability(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", d, 0, 1);
        }
        return this.value;
    }

    @Override
    public double getMean() {
        return this.value;
    }

    @Override
    public double getVariance() {
        return 0.0;
    }

    @Override
    public double getSupportLowerBound() {
        return this.value;
    }

    @Override
    public double getSupportUpperBound() {
        return this.value;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(UniformRandomProvider uniformRandomProvider) {
        return new ContinuousDistribution.Sampler(){

            @Override
            public double sample() {
                return ConstantContinuousDistribution.this.value;
            }
        };
    }
}

